<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! mirrors_interior_has_page_header() ) {
    return;
}

$mirrors_interior_classes = array( 'page-header' );
$mirrors_interior_style = mirrors_interior_page_header_style();

if ( $mirrors_interior_style ) {
    $mirrors_interior_classes[] = $mirrors_interior_style . '-page-header';
}

$mirrors_interior_visibility = get_theme_mod( 'mirrors_interior_page_header_visibility', 'all-devices' );

if ( 'hide-all-devices' === $mirrors_interior_visibility ) {
    // Don't show the header at all
    return;
}

if ( 'hide-tablet' === $mirrors_interior_visibility ) {
    $mirrors_interior_classes[] = 'hide-on-tablet';
} elseif ( 'hide-mobile' === $mirrors_interior_visibility ) {
    $mirrors_interior_classes[] = 'hide-on-mobile';
} elseif ( 'hide-tablet-mobile' === $mirrors_interior_visibility ) {
    $mirrors_interior_classes[] = 'hide-on-tablet-mobile';
}

$mirrors_interior_PAGE_TITLE_background_color = get_theme_mod('mirrors_interior_page_title_background_color_setting', '');

// Get the toggle switch value
$mirrors_interior_background_image_enabled = get_theme_mod('mirrors_interior_page_header_style', true);

// Add background image to the header if enabled
$mirrors_interior_background_image = get_theme_mod( 'mirrors_interior_page_header_background_image', '' );
$mirrors_interior_background_height = get_theme_mod( 'mirrors_interior_page_header_image_height', '200' );
$mirrors_interior_inline_style = '';

if ( $mirrors_interior_background_image_enabled && ! empty( $mirrors_interior_background_image ) ) {
    $mirrors_interior_inline_style .= 'background-image: url(' . esc_url( $mirrors_interior_background_image ) . '); ';
    $mirrors_interior_inline_style .= 'height: ' . esc_attr( $mirrors_interior_background_height ) . 'px; ';
    $mirrors_interior_inline_style .= 'background-size: cover; ';
    $mirrors_interior_inline_style .= 'background-position: center center; ';

    // Add the unique class if the background image is set
    $mirrors_interior_classes[] = 'has-background-image';
}

$mirrors_interior_classes = implode( ' ', $mirrors_interior_classes );
$mirrors_interior_heading = get_theme_mod( 'mirrors_interior_page_header_heading_tag', 'h1' );
$mirrors_interior_heading = apply_filters( 'mirrors_interior_page_header_heading', $mirrors_interior_heading );

?>

<?php do_action( 'mirrors_interior_before_page_header' ); ?>

<header class="<?php echo esc_attr( $mirrors_interior_classes ); ?>" style="<?php echo esc_attr( $mirrors_interior_inline_style ); ?> background-color: <?php echo esc_attr($mirrors_interior_PAGE_TITLE_background_color); ?>;">

    <?php do_action( 'mirrors_interior_before_page_header_inner' ); ?>

    <div class="asterthemes-wrapper page-header-inner">

        <?php if ( mirrors_interior_has_page_header() ) : ?>

            <<?php echo esc_attr( $mirrors_interior_heading ); ?> class="page-header-title">
                <?php echo wp_kses_post( mirrors_interior_get_page_title() ); ?>
            </<?php echo esc_attr( $mirrors_interior_heading ); ?>>

        <?php endif; ?>

        <?php if ( function_exists( 'mirrors_interior_breadcrumb' ) ) : ?>
            <?php mirrors_interior_breadcrumb(); ?>
        <?php endif; ?>

    </div><!-- .page-header-inner -->

    <?php do_action( 'mirrors_interior_after_page_header_inner' ); ?>

</header><!-- .page-header -->

<?php do_action( 'mirrors_interior_after_page_header' ); ?>