<?php

/**
 * The main template file
 * 
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package mirrors_interior
 */

get_header();

$mirrors_interior_column = get_theme_mod( 'mirrors_interior_archive_column_layout', 'column-1' );
?>
<main id="primary" class="site-main">

	<?php

	if ( have_posts() ) :

		if ( is_home() && ! is_front_page() ) :

		endif;
		?>

		<div class="mirrors_interior-archive-layout grid-layout <?php echo esc_attr( $mirrors_interior_column ); ?>">
			<?php
			/* Start the Loop */
			while ( have_posts() ) : the_post();

			get_template_part( 'template-parts/content', get_post_format() );

			endwhile;
			?>
		</div>
		<?php
		do_action( 'mirrors_interior_posts_pagination' );

	else :

		get_template_part( 'template-parts/content', 'none' );

	endif;
	?>

</main>

<?php
if ( mirrors_interior_is_sidebar_enabled() ) {
	get_sidebar();
}

get_footer();