<?php
/**
 * Mirrors Interior functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package mirrors_interior
 */

if ( ! defined( 'MIRRORS_INTERIOR_VERSION' ) ) {
	define( 'MIRRORS_INTERIOR_VERSION', '1.0.0' );
}
$mirrors_interior_theme_data = wp_get_theme();

if( ! defined( 'MIRRORS_INTERIOR_THEME_VERSION' ) ) define ( 'MIRRORS_INTERIOR_THEME_VERSION', $mirrors_interior_theme_data->get( 'Version' ) );
if( ! defined( 'MIRRORS_INTERIOR_THEME_NAME' ) ) define( 'MIRRORS_INTERIOR_THEME_NAME', $mirrors_interior_theme_data->get( 'Name' ) );

if ( ! function_exists( 'mirrors_interior_setup' ) ) :
	
	function mirrors_interior_setup() {
		
		load_theme_textdomain( 'mirrors-interior', get_template_directory() . '/languages' );

		add_theme_support( 'woocommerce' );

		add_theme_support( 'automatic-feed-links' );
		
		add_theme_support( 'title-tag' );

		add_theme_support( 'post-thumbnails' );

		register_nav_menus(
			array(
				'primary' => esc_html__( 'Primary', 'mirrors-interior' ),
			)
		);

		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
				'woocommerce',
			)
		);
		
		add_theme_support( 'post-formats', array(
			'image',
			'video',
			'gallery',
			'audio', 
		) );

		add_theme_support(
			'custom-background',
			apply_filters(
				'mirrors_interior_custom_background_args',
				array(
					'default-color' => '101010',
					'default-image' => '',
				)
			)
		);

		add_theme_support( 'customize-selective-refresh-widgets' );

		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);

		add_theme_support( 'align-wide' );

		add_theme_support( 'responsive-embeds' );

		/*  Demo Import */
		require get_parent_theme_file_path( '/theme-wizard/config.php' );
	}
endif;
add_action( 'after_setup_theme', 'mirrors_interior_setup' );

function mirrors_interior_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'mirrors_interior_content_width', 640 );
}
add_action( 'after_setup_theme', 'mirrors_interior_content_width', 0 );

function mirrors_interior_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'mirrors-interior' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'mirrors-interior' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		)
	);

	// Regsiter 4 footer widgets.
	$mirrors_interior_footer_widget_column = get_theme_mod('mirrors_interior_footer_widget_column','4');
	for ($i=1; $i<=$mirrors_interior_footer_widget_column; $i++) {
		register_sidebar( array(
			'name' => __( 'Footer  ', 'mirrors-interior' )  . $i,
			'id' => 'mirrors-interior-footer-widget-' . $i,
			'description' => __( 'The Footer Widget Area', 'mirrors-interior' )  . $i,
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<div class="widget-header"><h4 class="widget-title">',
			'after_title' => '</h4></div>',
		) );
	}
}
add_action( 'widgets_init', 'mirrors_interior_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function mirrors_interior_scripts() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	// Slick style.
	wp_enqueue_style( 'slick-style', get_template_directory_uri() . '/resource/css/slick' . $min . '.css', array(), '1.8.1' );

	// Fontawesome style.
	wp_enqueue_style( 'font-awesome-css', esc_url(get_template_directory_uri())."/resource/css/fontawesome-all.css" );

	// Main style.
	wp_enqueue_style( 'mirrors-interior-style', get_template_directory_uri() . '/style.css', array(), MIRRORS_INTERIOR_VERSION );

	// RTL style.
	wp_style_add_data('mirrors-interior-style', 'rtl', 'replace');

	// Animate CSS
	wp_enqueue_style( 'animate-style', get_template_directory_uri() . '/resource/css/animate.css' );
	
	// Navigation script.
	wp_enqueue_script( 'mirrors-interior-navigation-script', get_template_directory_uri() . '/resource/js/navigation' . $min . '.js', array(), MIRRORS_INTERIOR_VERSION, true );

	// Slick script.
	wp_enqueue_script( 'slick-script', get_template_directory_uri() . '/resource/js/slick' . $min . '.js', array( 'jquery' ), '1.8.1', true );

	// Wow script.
	wp_enqueue_script( 'wow-jquery', get_template_directory_uri() . '/resource/js/wow.js', array('jquery'),'' ,true );

	// Custom script.
	wp_enqueue_script( 'mirrors-interior-custom-script', get_template_directory_uri() . '/resource/js/custom.js', array( 'jquery' ), MIRRORS_INTERIOR_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// Include the file.
	require_once get_theme_file_path( 'theme-library/function-files/wptt-webfont-loader.php' );

	// Load the webfont.
	wp_enqueue_style(
		'play',
		wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Play:wght@400;700&display=swap' ),
		array(),
		'1.0'
	);

	// Load the webfont.
	wp_enqueue_style(
		'readex',
		wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Readex+Pro:wght@200;300;400;500;600;700&display=swap' ),
		array(),
		'1.0'
	);

}
add_action( 'wp_enqueue_scripts', 'mirrors_interior_scripts' );

//Change number of products per page 
add_filter( 'loop_shop_per_page', 'mirrors_interior_products_per_page' );
function mirrors_interior_products_per_page( $cols ) {
  	return  get_theme_mod( 'mirrors_interior_products_per_page',9);
}

// Change number or products per row 
add_filter('loop_shop_columns', 'mirrors_interior_loop_columns');
	if (!function_exists('mirrors_interior_loop_columns')) {
	function mirrors_interior_loop_columns() {
		return get_theme_mod( 'mirrors_interior_products_per_row', 3 );
	}
}


/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/theme-library/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/theme-library/function-files/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/theme-library/function-files/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/theme-library/customizer.php';

/**
 * Breadcrumb
 */
require get_template_directory() . '/theme-library/function-files/class-breadcrumb-trail.php';

/**
 * Load WooCommerce compatibility file.
 */
if ( class_exists( 'WooCommerce' ) ) {
	require get_template_directory() . '/theme-library/function-files/woocommerce.php';
}

/**
 * Getting Started
*/
require get_template_directory() . '/theme-library/getting-started/getting-started.php';

/**
 * Google Fonts
 */
require get_template_directory() . '/theme-library/function-files/google-fonts.php';

/**
 * Dynamic CSS
 */
require get_template_directory() . '/theme-library/dynamic-css.php';

/**
 * Customizer Settings Functions
*/
require get_template_directory() . '/theme-library/function-files/customizer-settings-functions.php';

function mirrors_interior_links_setup() {
	if ( ! defined( 'MIRRORS_INTERIOR_PREMIUM_PAGE' ) ) {
	define('MIRRORS_INTERIOR_PREMIUM_PAGE',__('https://asterthemes.com/products/mirrors-interior-wordpress-theme','mirrors-interior'));
	}
	if ( ! defined( 'MIRRORS_INTERIOR_THEME_PAGE' ) ) {
		define('MIRRORS_INTERIOR_THEME_PAGE',__('https://asterthemes.com/products/mirrors-interior','mirrors-interior'));
	}
	if ( ! defined( 'MIRRORS_INTERIOR_SUPPORT' ) ) {
	define('MIRRORS_INTERIOR_SUPPORT',__('https://wordpress.org/support/theme/mirrors-interior/','mirrors-interior'));
	}
	if ( ! defined( 'MIRRORS_INTERIOR_REVIEW' ) ) {
	define('MIRRORS_INTERIOR_REVIEW',__('https://wordpress.org/support/theme/mirrors-interior/reviews/','mirrors-interior'));
	}
	if ( ! defined( 'MIRRORS_INTERIOR_PRO_DEMO' ) ) {
	define('MIRRORS_INTERIOR_PRO_DEMO',__('https://demo.asterthemes.com/mirrors-interior/','mirrors-interior'));
	}
	if ( ! defined( 'MIRRORS_INTERIOR_THEME_DOCUMENTATION' ) ) {
	define('MIRRORS_INTERIOR_THEME_DOCUMENTATION',__('https://demo.asterthemes.com/docs/mirrors-interior-free/','mirrors-interior'));
	}
	if ( ! defined( 'MIRRORS_INTERIOR_PREMIUM_DOCUMENTATION' ) ) {
	define('MIRRORS_INTERIOR_PREMIUM_DOCUMENTATION',__('https://demo.asterthemes.com/docs/mirrors-interior-pro/','mirrors-interior'));
	}
	if ( ! defined( 'MIRRORS_INTERIOR_BUNDLE_PAGE' ) ) {
		define('MIRRORS_INTERIOR_BUNDLE_PAGE',__('https://asterthemes.com/products/wp-theme-bundle','mirrors-interior'));
	}
}
add_action('after_setup_theme', 'mirrors_interior_links_setup');

// Enqueue Customizer live preview script
function mirrors_interior_customizer_live_preview() {
    wp_enqueue_script(
        'mirrors-interior-customizer',
        get_template_directory_uri() . '/js/customizer.js',
        array('jquery', 'customize-preview'),
        '',
        true
    );
}
add_action('customize_preview_init', 'mirrors_interior_customizer_live_preview');

// Featured Image Dimension
function mirrors_interior_blog_post_featured_image_dimension(){
	if(get_theme_mod('mirrors_interior_blog_post_featured_image_dimension') == 'custom' ) {
		return true;
	}
	return false;
}

add_filter( 'woocommerce_enable_setup_wizard', '__return_false' );