// Slider Section
jQuery(document).ready(function($) {
  const mining_logistic_section = $('.slider-section');
  const mining_logistic_owl = mining_logistic_section.find('.owl-carousel').owlCarousel({
    loop: true,
    margin: 15,
    nav: false,
    dots: false,
    rtl: false,
    items: 1,
    autoplay: true,
  });

  // Custom navigation
  mining_logistic_section.find('.custom-next').click(() => 
    mining_logistic_owl.trigger('next.owl.carousel')
  );
  mining_logistic_section.find('.custom-prev').click(() => 
    mining_logistic_owl.trigger('prev.owl.carousel')
  );

  // Custom dots (thumbnails)
  const mining_logistic_dots = mining_logistic_section.find('.custom-dots').empty();
  mining_logistic_section.find('.owl-item:not(.cloned)').each(function(i) {
    const img = $(this).find('img').attr('src');
    if (img) mining_logistic_dots.append(
      `<button class="dot" data-index="${i}"><img src="${img}" alt="thumb-${i}"></button>`
    );
  });

  mining_logistic_dots.on('click', '.dot', function() {
    mining_logistic_owl.trigger('to.owl.carousel', [$(this).data('index'), 300]);
  });

  // Slide count
  const mining_logistic_count = mining_logistic_section.find('.slide-count');
  const mining_logistic_total = mining_logistic_section.find('.owl-item:not(.cloned)').length;
  const mining_logistic_pad = n => (n < 10 ? '0' + n : n);
  mining_logistic_count.html(`<span class="current-slide">01</span> / <span class="total-slide">${mining_logistic_pad(mining_logistic_total)}</span>`);

  // Update on change
  mining_logistic_owl.on('changed.owl.carousel', function(e) {
    const index = (e.item.index - e.relatedTarget._clones.length / 2 + e.item.count) % e.item.count;
    mining_logistic_dots.find('.dot').removeClass('active').eq(index).addClass('active');
    mining_logistic_count.find('.current-slide').text(mining_logistic_pad(index + 1));
  });

  // Set first active
  mining_logistic_dots.find('.dot').eq(0).addClass('active');
});

// Testimonial Section
jQuery(document).ready(function() {
  jQuery('.testimonial-section .owl-carousel').owlCarousel({
    loop: true,
    margin: 15,
    nav: true,
    navText: ["<span class='left-btn p-3'></span>", "<span class='right-btn p-3'></span>"], 
    dots: false,
    rtl: false,
    responsive: {
    0: { 
      items: 1 
    },
    768: { 
      items: 2 
    },
    992: { 
      items: 2 
    },
    1200: { 
      items: 3 
    }
  },
  autoplay: true,
  });
});

// News Section
jQuery(document).ready(function() {
  jQuery('.news-section .owl-carousel').owlCarousel({
    loop: true,
    margin: 15,
    nav: false, 
    dots: false,
    rtl: false,
    responsive: {
    0: { 
      items: 1 
    },
    768: { 
      items: 2 
    },
    992: { 
      items: 2 
    },
    1200: { 
      items: 3 
    }
  },
  autoplay: true,
  });
});

// Scroll to Top
window.onscroll = function() {
  const mining_logistic_button = document.querySelector('.scroll-top-box');
  if (document.body.scrollTop > 100 || document.documentElement.scrollTop > 100) {
    mining_logistic_button.style.display = "block";
  } else {
    mining_logistic_button.style.display = "none";
  }
};

document.querySelector('.scroll-top-box a').onclick = function(event) {
  event.preventDefault();
  window.scrollTo({top: 0, behavior: 'smooth'});
};