<?php
//about theme info

function mining_logistic_menu() {
	add_theme_page( esc_html__( 'Mining-logistic', 'mining-logistic' ), esc_html__( 'Mining-logistic Theme', 'mining-logistic' ), 'edit_theme_options', 'mining-logistic-info', 'mining_logistic_theme_page_display' );
}
add_action( 'admin_menu', 'mining_logistic_menu' );

// Add a Custom CSS file to WP Admin Area
function mining_logistic_admin_theme_style() {
	wp_enqueue_style('mining-logistic-custom-admin-style', esc_url(get_template_directory_uri()) . '/css/admin-style.css');
	wp_enqueue_script('mining-logistic-tabs', esc_url(get_template_directory_uri()) . '/inc/core/js/tab.js');
}
add_action('admin_enqueue_scripts', 'mining_logistic_admin_theme_style');

//guidline for about theme
function mining_logistic_theme_page_display() { 
	//custom function about theme customizer
	$mining_logistic_return = add_query_arg( array()) ;
	$mining_logistic_theme = wp_get_theme( 'mining-logistic' );
?>

<div class="wrapper-info">
	<div class="tab-sec">
    	
    	<div class="tab">
			<button class="tablinks" onclick="mining_logistic_open_tab(event, 'lite_theme')"><?php esc_html_e( 'Free Setup', 'mining-logistic' ); ?></button>
			<button class="tablinks" onclick="mining_logistic_open_tab(event, 'theme_pro')"><?php esc_html_e( 'Get Premium', 'mining-logistic' ); ?></button>
  			<button class="tablinks" onclick="mining_logistic_open_tab(event, 'free_pro')"><?php esc_html_e( 'Free VS Premium', 'mining-logistic' ); ?></button>
  			<button class="tablinks" onclick="mining_logistic_open_tab(event, 'get_bundle')"><?php esc_html_e( 'WP Theme Bundle', 'mining-logistic' ); ?></button>
		</div>

		<?php 
			$mining_logistic_plugin_custom_css = '';
			if(class_exists('Ibtana_Visual_Editor_Menu_Class')){
				$mining_logistic_plugin_custom_css ='display: block';
			}
		?>

		<div id="lite_theme" class="tabcontent open">
			<div class="lite-theme-tab">
				<h3><?php esc_html_e( 'Mining logistic', 'mining-logistic' ); ?></h3>
				<hr class="h3hr">
			  	<p><?php esc_html_e('Mining Logistic is a conversion-focused, responsive theme built for mining logistics companies, mineral transportation services, supply chain management firms, industrial transport providers, freight forwarding businesses, warehouse management services, and product-based industrial suppliers, offering a professional platform to showcase mining services, logistics solutions, and sell industrial equipment, bulk materials, spare parts, and heavy machinery through seamless WooCommerce integration suited for ecommerce templates, dropshipping shops, and online store building. It includes customizable homepage layouts, dedicated service sections, project portfolios, team profiles, product showcases, and image galleries, along with built-in SEO optimization using the Yoast SEO plugin to improve visibility for search terms such as mining transport services, industrial logistics, freight services, mineral supply chain, cargo handling, and heavy equipment suppliers. Contact Form 7 enables easy lead capture, quotation requests, and client inquiries, while compatibility with logistics tracking plugins and secure selling tools supports efficient operations. With drag-and-drop customization, flexible color schemes, typography options, Google Fonts support, fast loading performance, mobile-friendly design, and cross-browser compatibility, Mining Logistic delivers a modern, conversion-driven solution for mining companies, industrial logistics providers, and supply businesses looking to attract clients, promote services, and grow their digital presence effectively.
LiveDemo: https://www.vwthemes.net/mining-industry-pro/','mining-logistic'); ?></p>
			  	<div class="col-left-inner">
					<div class="pro-links">
				    	<a href="<?php echo esc_url( admin_url() . 'site-editor.php' ); ?>" target="_blank"><?php esc_html_e('Edit Your Site', 'mining-logistic'); ?></a>
						<a href="<?php echo esc_url( home_url() ); ?>" target="_blank"><?php esc_html_e('Visit Your Site', 'mining-logistic'); ?></a>
					</div>
					<div class="support-forum-col-section">
						<div class="support-forum-col">
							<h4><?php esc_html_e('Having Trouble, Need Support?', 'mining-logistic'); ?></h4>
							<p> <?php esc_html_e('Our dedicated team is well prepared to help you out in case of queries and doubts regarding our theme.', 'mining-logistic'); ?></p>
							<div class="info-link">
								<a href="<?php echo esc_url( MINING_LOGISTIC_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support Forum', 'mining-logistic'); ?></a>
							</div>
						</div>
						<div class="support-forum-col">
							<h4><?php esc_html_e('Reviews & Testimonials', 'mining-logistic'); ?></h4>
							<p> <?php esc_html_e('All the features and aspects of this WordPress Theme are phenomenal. I\'d recommend this theme to all.', 'mining-logistic'); ?>  </p>
							<div class="info-link">
								<a href="<?php echo esc_url( MINING_LOGISTIC_REVIEW ); ?>" target="_blank"><?php esc_html_e('Reviews', 'mining-logistic'); ?></a>
							</div>
						</div>
						<div class="support-forum-col">
							<h4><?php esc_html_e('Theme Documentation', 'mining-logistic'); ?></h4>
							<p> <?php esc_html_e('If you need any assistance regarding setting up and configuring the Theme, our documentation is there.', 'mining-logistic'); ?>  </p>
							<div class="info-link">
								<a href="<?php echo esc_url( MINING_LOGISTIC_FREE_DOC ); ?>" target="_blank"><?php esc_html_e('Free Theme Documentation', 'mining-logistic'); ?></a>
							</div>
						</div>
					</div>
			  	</div>
			</div>
		</div>

		<div id="theme_pro" class="tabcontent">		  	
			<div class="pro-info">
				<div class="col-left-pro">
					<h3><?php esc_html_e( 'Premium Theme Information', 'mining-logistic' ); ?></h3>
					<hr class="h3hr">
			    	<p><?php esc_html_e('Designed specifically for companies and professionals in the mining industry, the Mining WordPress Theme delivers a modern and sophisticated online presence tailored to mineral extraction, geological surveys, and mining operations. Whether you’re in underground mining, surface mining, coal mining, or rare earth mining, this theme provides a clean and responsive layout that highlights your services, equipment, and project accomplishments. With retina-ready visuals, optimized code, and SEO-friendly features, it ensures fast load times and enhanced visibility. Showcase heavy machinery, mining trucks, drilling rigs, crushers, and mineral processing units effortlessly. Its customization options allow easy branding for mining contractors, consultants, and engineers. The theme supports testimonials, contact forms, and banners to engage clients, promote safety gear, and offer insights into mine planning or environmental impact assessments. It\'s also ideal for promoting sustainable mining practices and green mining initiatives. Integrated with social media and built on a secure, mobile-friendly framework, it’s perfect for any mining company aiming to stay ahead in the global mining market.','mining-logistic'); ?></p>
			    	<div class="pro-links">
				    	<a href="<?php echo esc_url( MINING_LOGISTIC_LIVE_DEMO ); ?>" target="_blank" class="demo-btn"><?php esc_html_e('Live Demo', 'mining-logistic'); ?></a>
						<a href="<?php echo esc_url( MINING_LOGISTIC_BUY_NOW ); ?>" target="_blank" class="prem-btn"><?php esc_html_e('Buy Premium', 'mining-logistic'); ?></a>
						<a href="<?php echo esc_url( MINING_LOGISTIC_PRO_DOC ); ?>" target="_blank" class="doc-btn"><?php esc_html_e('Documentation', 'mining-logistic'); ?></a>
					</div>
			    </div>
			    <div class="col-right-pro scroll-image-wrapper">
			    	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/premium-image.jpg" alt="" class="pro-img" />		    	
			    </div>
			</div>		    
		</div>

		<div id="free_pro" class="tabcontent">
		  	<div class="featurebox">
			    <h3><?php esc_html_e( 'Theme Features', 'mining-logistic' ); ?></h3>
				<hr class="h3hr">
				<div class="table-image">
					<table class="tablebox">
						<thead>
							<tr>
								<th><?php esc_html_e('Features', 'mining-logistic'); ?></th>
								<th><?php esc_html_e('Free Themes', 'mining-logistic'); ?></th>
								<th><?php esc_html_e('Premium Themes', 'mining-logistic'); ?></th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td><?php esc_html_e('Easy Setup', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Responsive Design', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('SEO Friendly', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Banner Settings', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Template Pages', 'mining-logistic'); ?></td>
								<td class="table-img"><?php esc_html_e('1', 'mining-logistic'); ?></td>
								<td class="table-img"><?php esc_html_e('14', 'mining-logistic'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Home Page Template', 'mining-logistic'); ?></td>
								<td class="table-img"><?php esc_html_e('1', 'mining-logistic'); ?></td>
								<td class="table-img"><?php esc_html_e('1', 'mining-logistic'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Theme sections', 'mining-logistic'); ?></td>
								<td class="table-img"><?php esc_html_e('2', 'mining-logistic'); ?></td>
								<td class="table-img"><?php esc_html_e('12', 'mining-logistic'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Contact us Page Template', 'mining-logistic'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('1', 'mining-logistic'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Blog Templates & Layout', 'mining-logistic'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('3(Full width/Left/Right Sidebar)', 'mining-logistic'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Section Reordering', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Demo Importer', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Full Documentation', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Latest WordPress Compatibility', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Support 3rd Party Plugins', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Secure and Optimized Code', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Exclusive Functionalities', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Section Enable / Disable', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Section Google Font Choices', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Gallery', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Simple & Mega Menu Option', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Support to add custom CSS / JS ', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Shortcodes', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Custom Background, Colors, Header, Logo & Menu', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Premium Membership', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Budget Friendly Value', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Priority Error Fixing', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Custom Feature Addition', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('All Access Theme Pass', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Seamless Customer Support', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('WordPress 6.4 or later', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('PHP 8.2 or 8.3', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('MySQL 5.6 (or greater) | MariaDB 10.0 (or greater)', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Influence Registration', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Detailed Influencer Portfolio', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Premium Pricing Plan', 'mining-logistic'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
							<td></td>
							<td class="table-img"></td>
							<td class="update-link"><a href="<?php echo esc_url( MINING_LOGISTIC_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Upgrade to Pro', 'mining-logistic'); ?></a></td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>

		<div id="get_bundle" class="tabcontent">	
			<div class="bundle-info">
				<div class="col-left-pro">
			   		<h3><?php esc_html_e( 'WP Theme Bundle', 'mining-logistic' ); ?></h3>
			   		<hr class="h3hr">
			    	<p><?php esc_html_e('Enhance your website effortlessly with our WP Theme Bundle. Get access to 400+ premium WordPress themes and 5+ powerful plugins, all designed to meet diverse business needs. Enjoy seamless integration with any plugins, ultimate customization flexibility, and regular updates to keep your site current and secure. Plus, benefit from our dedicated customer support, ensuring a smooth and professional web experience.','mining-logistic'); ?></p>
			    	<div class="feature">
			    		<h4><?php esc_html_e( 'Features:', 'mining-logistic' ); ?></h4>
			    		<p><img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/tick.png" alt="" /><?php esc_html_e('400+ Premium Themes & 5+ Plugins.', 'mining-logistic'); ?></p>
			    		<p><img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/tick.png" alt="" /><?php esc_html_e('Seamless Integration.', 'mining-logistic'); ?></p>
			    		<p><img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/tick.png" alt="" /><?php esc_html_e('Customization Flexibility.', 'mining-logistic'); ?></p>
			    		<p><img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/tick.png" alt="" /><?php esc_html_e('Regular Updates.', 'mining-logistic'); ?></p>
			    		<p><img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/tick.png" alt="" /><?php esc_html_e('Dedicated Support.', 'mining-logistic'); ?></p>
			    	</div>
			    	<p><?php esc_html_e('Upgrade now and give your website the professional edge it deserves, all at an unbeatable price of $99!', 'mining-logistic'); ?></p>
			    	<div class="pro-links">
						<a href="<?php echo esc_url( MINING_LOGISTIC_THEME_BUNDLE_BUY_NOW ); ?>" target="_blank" class="bundle-buy"><?php esc_html_e('Get Bundle', 'mining-logistic'); ?></a>
						<a href="<?php echo esc_url( MINING_LOGISTIC_THEME_BUNDLE_DOC ); ?>" target="_blank" class="bundle-doc"><?php esc_html_e('Documentation', 'mining-logistic'); ?></a>
					</div>
			   	</div>
			   	<div class="col-right-pro scroll-image-wrapper">
			    	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/bundle.jpg" alt="" />
			   	</div>
			</div>	  	
		</div>
	</div>
	<div class="coupen-code-section">
		<div class="sshot-section">
			<div class="sshot-inner">
				<h2><?php esc_html_e( 'Welcome To Mining Logistic', 'mining-logistic' ); ?> <span class="version"><?php esc_html_e( 'Version', 'mining-logistic' ); ?>: <?php echo esc_html($mining_logistic_theme['Version']);?></span></h2>
		    	<p><?php esc_html_e('All Our Wordpress Themes Are Modern, Minimalist, 100% Responsive, Seo-Friendly,Feature-Rich, And Multipurpose That Best Suit Designers, Bloggers And Other Professionals Who Are Working In The Creative Fields.','mining-logistic'); ?></p>
		    	<div class="btn-section">
			    	<div class="pro-links">
				    	<a href="<?php echo esc_url( MINING_LOGISTIC_LIVE_DEMO ); ?>" target="_blank" class="demo-btn"><?php esc_html_e('Live Demo', 'mining-logistic'); ?></a>
						<a href="<?php echo esc_url( MINING_LOGISTIC_BUY_NOW ); ?>" target="_blank" class="prem-btn"><?php esc_html_e('Buy Premium', 'mining-logistic'); ?></a>
						<a href="<?php echo esc_url( MINING_LOGISTIC_PRO_DOC ); ?>" target="_blank" class="doc-btn"><?php esc_html_e('Documentation', 'mining-logistic'); ?></a>
						
					</div>
			    	
			    </div>
			</div>
	    	<div class="bundle-banner">
	    		<div class="bundle-img">
	    			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/bundle-notice.png" alt="" />
	    		</div>
	    		<div class="bundle-text">
		  			<h2><?php esc_html_e('WP THEME BUNDLE','mining-logistic'); ?></h2>
					<h4><?php esc_html_e('Get Access to 400+ Premium WordPress Themes At Just $99','mining-logistic'); ?></h4>
					<div class="bundle-button">
			  			<a href="<?php echo esc_url( 'https://www.vwthemes.com/discount/FREEBREF?redirect=/products/wp-theme-bundle'); ?>" target="_blank"><?php esc_html_e('Get 10% OFF On Bundle', 'mining-logistic'); ?></a>
			  		</div>
		  		</div>
	    	</div>
	    </div>
	    <div class="coupen-section">
	    	<div class="logo-section">
			  	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png" alt="" />
		  	</div>
		  	<div class="logo-right">	
		  		<div class="logo-text">
		  			<h2><?php esc_html_e('GET PRO','mining-logistic'); ?></h2>
					<h4><?php esc_html_e('20% Off','mining-logistic'); ?></h4>
		  		</div>						
			</div>
	    </div>
	</div>
</div>

<?php } ?>