jQuery(document).ready(function ($) {
    // Attach click event to the dismiss button
    $(document).on('click', '.welcome-notice button.notice-dismiss', function () {
        // Dismiss the notice via AJAX
        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: {
                action: 'mining_logistic_dismissed_notice',
            },
            success: function () {
                // Remove the notice on success
                $('.notice[data-notice="example"]').remove();
            }
        });
    });
});

// Plugin – AI Content Writer plugin activation
document.addEventListener('DOMContentLoaded', function () {
    const mining_logistic_button = document.getElementById('install-activate-button');

    if (!mining_logistic_button) return;

    mining_logistic_button.addEventListener('click', function (e) {
        e.preventDefault();

        const mining_logistic_redirectUrl = mining_logistic_button.getAttribute('data-redirect');

        // Step 1: Check if plugin is already active
        const mining_logistic_checkData = new FormData();
        mining_logistic_checkData.append('action', 'check_plugin_activation');

        fetch(installPluginData.ajaxurl, {
            method: 'POST',
            body: mining_logistic_checkData,
        })
        .then(res => res.json())
        .then(res => {
            if (res.success && res.data.active) {
                // Plugin is already active → just redirect
                window.location.href = mining_logistic_redirectUrl;
            } else {
                // Not active → proceed with install + activate
                mining_logistic_button.textContent = 'Installing & Activating...';

                const mining_logistic_installData = new FormData();
                mining_logistic_installData.append('action', 'install_and_activate_required_plugin');
                mining_logistic_installData.append('_ajax_nonce', installPluginData.nonce);

                fetch(installPluginData.ajaxurl, {
                    method: 'POST',
                    body: mining_logistic_installData,
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        window.location.href = mining_logistic_redirectUrl;
                    } else {
                        alert('Activation error: ' + (res.data?.message || 'Unknown error'));
                        mining_logistic_button.textContent = 'Try Again';
                    }
                })
                .catch(error => {
                    alert('Request failed: ' + error.message);
                    mining_logistic_button.textContent = 'Try Again';
                });
            }
        })
        .catch(error => {
            alert('Check request failed: ' + error.message);
        });
    });
});
