<?php
// Add Getstart admin notice
function mining_logistic_admin_notice() { 
    global $mining_logistic_pagenow;
    $mining_logistic_theme_args      = wp_get_theme();
    $mining_logistic_meta            = get_option( 'mining_logistic_admin_notice' );
    $mining_logistic_name            = $mining_logistic_theme_args->__get( 'Name' );
    $mining_logistic_current_screen  = get_current_screen();

    if( !$mining_logistic_meta ){
        if( is_network_admin() ){
            return;
        }

        if( ! current_user_can( 'manage_options' ) ){
            return;
        } if($mining_logistic_current_screen->base != 'appearance_page_mining-logistic-guide-page' && $mining_logistic_current_screen->id != 'appearance_page_mining-logistic-info' && $mining_logistic_current_screen->base != 'toplevel_page_cretats-theme-showcase' ) { ?>
        <div class="notice notice-success is-dismissible welcome-notice">
            <div class="notice-row">
                <div class="notice-text">
                    <p class="welcome-text1"><?php esc_html_e( '🎉 Welcome to VW Themes,', 'mining-logistic' ); ?></p>
                    <p class="welcome-text2"><?php esc_html_e( 'You are now using the Mining Logistic, a beautifully designed theme to kickstart your website.', 'mining-logistic' ); ?></p>
                    <p class="welcome-text3"><?php esc_html_e( 'To help you get started quickly, use the options below:', 'mining-logistic' ); ?></p>

                    <span class="import-btn">
                        <a href="javascript:void(0);" id="install-activate-button" class="button admin-button info-button">
                           <?php echo __('GET STARTED', 'mining-logistic'); ?>
                        </a>
                        <script type="text/javascript">
                            document.getElementById('install-activate-button').addEventListener('click', function () {
                                const mining_logistic_button = this;
                                const mining_logistic_redirectUrl = '<?php echo esc_url(admin_url("themes.php?page=mining-logistic-info")); ?>';
                                // First, check if plugin is already active
                                jQuery.post(ajaxurl, { action: 'check_plugin_activation' }, function (response) {
                                    if (response.success && response.data.active) {
                                        // Plugin already active — just redirect
                                        window.location.href = mining_logistic_redirectUrl;
                                    } else {
                                        // Show Installing & Activating only if not already active
                                        mining_logistic_button.textContent = 'Installing & Activating...';

                                        jQuery.post(ajaxurl, {
                                            action: 'install_and_activate_required_plugin',
                                            nonce: '<?php echo wp_create_nonce("install_activate_nonce"); ?>'
                                        }, function (response) {
                                            if (response.success) {
                                                window.location.href = mining_logistic_redirectUrl; 
                                            } else {
                                                alert('Failed to activate the plugin.');
                                                mining_logistic_button.textContent = 'Try Again';
                                            }
                                        });
                                    }
                                });
                            });
                        </script>
                    </span>

                    <span class="demo-btn">
                        <a href="https://www.vwthemes.net/mining-industry-pro/" class="button button-primary" target="_blank">
                            <?php esc_html_e( 'VIEW DEMO', 'mining-logistic' ); ?>
                        </a>
                    </span>

                    <span class="upgrade-btn">
                        <a href="https://www.vwthemes.com/products/mining-wordpress-theme" class="button button-primary" target="_blank">
                            <?php esc_html_e( 'UPGRADE TO PRO', 'mining-logistic' ); ?>
                        </a>
                    </span>

                    <span class="bundle-btn">
                        <a href="https://www.vwthemes.com/products/wp-theme-bundle" class="button button-primary" target="_blank">
                            <?php esc_html_e( 'BUNDLE OF 400+ THEMES', 'mining-logistic' ); ?>
                        </a>
                    </span>
                </div>

                <div class="notice-img1">
                    <img src="<?php echo esc_url( get_template_directory_uri() . '/images/arrow-notice.png' ); ?>" width="180" alt="<?php esc_attr_e( 'Mining-logistic', 'mining-logistic' ); ?>" />
                </div>

                <div class="notice-img2">
                    <img src="<?php echo esc_url( get_template_directory_uri() . '/images/bundle-notice.png' ); ?>" width="180" alt="<?php esc_attr_e( 'Mining-logistic', 'mining-logistic' ); ?>" />
                </div>
            </div>
        </div>
       <?php

    }?>
        <?php

    }
}

add_action( 'admin_notices', 'mining_logistic_admin_notice' );

if( ! function_exists( 'mining_logistic_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
*/
function mining_logistic_update_admin_notice(){
    if ( isset( $_GET['mining_logistic_admin_notice'] ) && $_GET['mining_logistic_admin_notice'] = '1' ) {
        update_option( 'mining_logistic_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'mining_logistic_update_admin_notice' );

//After Switch theme function
add_action('after_switch_theme', 'mining_logistic_getstart_setup_options');
function mining_logistic_getstart_setup_options () {
    update_option('mining_logistic_admin_notice', FALSE );
}

