<?php
/**
 * Mining Logistic: Block Patterns
 *
 * @since Mining Logistic 1.0
 */

 /**
  * Get patterns content.
  *
  * @param string $file_name Filename.
  * @return string
  */
function mining_logistic_get_pattern_content( $file_name ) {
	ob_start();
	include get_theme_file_path( '/patterns/' . $file_name . '.php' );
	$output = ob_get_contents();
	ob_end_clean();
	return $output;
}

/**
 * Registers block patterns and categories.
 *
 * @since Mining Logistic 1.0
 *
 * @return void
 */
function mining_logistic_register_block_patterns() {

	$patterns = array(
		'header-default' => array(
			'title'      => __( 'Default header', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-headers' ),
			'blockTypes' => array( 'parts/header' ),
		),
		'footer-default' => array(
			'title'      => __( 'Default footer', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-footers' ),
			'blockTypes' => array( 'parts/footer' ),
		),
		'home-slider' => array(
			'title'      => __( 'Home Slider', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-home-slider' ),
		),
		'team-section' => array(
			'title'      => __( 'Team Section', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-team-section' ),
		),
		'about-us-section' => array(
			'title'      => __( 'About Us Section', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-about-us-section' ),
		),
		'testimonial-section' => array(
			'title'      => __( 'Testimonial Section', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-testimonial-section' ),
		),
		'news-section' => array(
			'title'      => __( 'News Section', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-news-section' ),
		),
		'faq-section' => array(
			'title'      => __( 'FAQ Section', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-faq-section' ),
		),
		'primary-sidebar' => array(
			'title'    => __( 'Primary Sidebar', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-sidebars' ),
		),
		'hidden-404' => array(
			'title'    => __( '404 content', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-pages' ),
		),
		'post-listing-single-column' => array(
			'title'    => __( 'Post Single Column', 'mining-logistic' ),
			//'inserter' => false,
			'categories' => array( 'mining-logistic-query' ),
		),
		'post-listing-two-column' => array(
			'title'    => __( 'Post Two Column', 'mining-logistic' ),
			//'inserter' => false,
			'categories' => array( 'mining-logistic-query' ),
		),
		'post-listing-three-column' => array(
			'title'    => __( 'Post Three Column', 'mining-logistic' ),
			//'inserter' => false,
			'categories' => array( 'mining-logistic-query' ),
		),
		'post-listing-four-column' => array(
			'title'    => __( 'Post Four Column', 'mining-logistic' ),
			//'inserter' => false,
			'categories' => array( 'mining-logistic-query' ),
		),
		'feature-post-column' => array(
			'title'    => __( 'Feature Post Column', 'mining-logistic' ),
			//'inserter' => false,
			'categories' => array( 'mining-logistic-query' ),
		),
		'comment-section-1' => array(
			'title'    => __( 'Comment Section 1', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-comment-sections' ),
		),
		'cover-with-post-title' => array(
			'title'    => __( 'Cover With Post Title', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-banner-sections' ),
		),
		'cover-with-search-title' => array(
			'title'    => __( 'Cover With Search Title', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-banner-sections' ),
		),
		'cover-with-archive-title' => array(
			'title'    => __( 'Cover With Archive Title', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-banner-sections' ),
		),
		'cover-with-index-title' => array(
			'title'    => __( 'Cover With Index Title', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-banner-sections' ),
		),
		'theme-button' => array(
			'title'    => __( 'Theme Button', 'mining-logistic' ),
			'categories' => array( 'mining-logistic-theme-button' ),
		),
	);

	$block_pattern_categories = array(
		'mining-logistic-footers' => array( 'label' => __( 'Footers', 'mining-logistic' ) ),
		'mining-logistic-headers' => array( 'label' => __( 'Headers', 'mining-logistic' ) ),
		'mining-logistic-pages'   => array( 'label' => __( 'Pages', 'mining-logistic' ) ),
		'mining-logistic-query'   => array( 'label' => __( 'Query', 'mining-logistic' ) ),
		'mining-logistic-sidebars'   => array( 'label' => __( 'Sidebars', 'mining-logistic' ) ),
		'mining-logistic-home-slider'   => array( 'label' => __( 'Home Slider', 'mining-logistic' ) ),
		'mining-logistic-team-section'   => array( 'label' => __( 'Team Section', 'mining-logistic' ) ),
		'mining-logistic-about-us-section'   => array( 'label' => __( 'About Us Section', 'mining-logistic' ) ),
		'mining-logistic-testimonial-section'   => array( 'label' => __( 'Testimonial Section', 'mining-logistic' ) ),
		'mining-logistic-news-section'   => array( 'label' => __( 'News Section', 'mining-logistic' ) ),
		'mining-logistic-faq-section'   => array( 'label' => __( 'FAQ Section', 'mining-logistic' ) ),
		'mining-logistic-comment-section'   => array( 'label' => __( 'Comment Sections', 'mining-logistic' ) ),
		'mining-logistic-theme-button'   => array( 'label' => __( 'Theme Button Sections', 'mining-logistic' ) ),
	);

	/**
	 * Filters the theme block pattern categories.
	 *
	 * @since Mining Logistic 1.0
	 *
	 * @param array[] $block_pattern_categories {
	 *     An associative array of block pattern categories, keyed by category name.
	 *
	 *     @type array[] $properties {
	 *         An array of block category properties.
	 *
	 *         @type string $label A human-readable label for the pattern category.
	 *     }
	 * }
	 */
	$block_pattern_categories = apply_filters( 'mining_logistic_block_pattern_categories', $block_pattern_categories );

	foreach ( $block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}

	/**
	 * Filters the theme block patterns.
	 *
	 * @since Mining Logistic 1.0
	 *
	 * @param array $block_patterns List of block patterns by name.
	 */
	$patterns = apply_filters( 'mining_logistic_block_patterns', $patterns );

	foreach ( $patterns as $block_pattern => $pattern ) {
		$pattern['content'] = mining_logistic_get_pattern_content( $block_pattern );
		register_block_pattern(
			'mining-logistic/' . $block_pattern,
			$pattern
		);
	}
}
add_action( 'init', 'mining_logistic_register_block_patterns', 9 );
