jQuery(document).ready(function($) {

  // IMAGE HOVER METABOX
  var file_frame;

  jQuery.fn.upload_hover_image = function( button ) {
    var button_id = button.attr('id');
    var field_id = button_id.replace( '_button', '' );

    // If the media frame already exists, reopen it.
    if ( file_frame ) {
      file_frame.open();
      return;
    }

    // Create the media frame.
    file_frame = wp.media.frames.file_frame = wp.media({
      title: jQuery( this ).data( 'uploader_title' ),
      button: {
        text: jQuery( this ).data( 'uploader_button_text' ),
      },
      multiple: false
    });

    // When an image is selected, run a callback.
    file_frame.on( 'select', function() {
      var attachment = file_frame.state().get('selection').first().toJSON();
      jQuery("#"+field_id).val(attachment.id);
      jQuery("#hoverimagediv img").attr('src',attachment.url);
      jQuery( '#hoverimagediv img' ).show();
      jQuery( '#' + button_id ).attr( 'id', 'remove_hover_image_button' );
      jQuery( '#remove_hover_image_button' ).text( 'Remove hover image' );
    });

    // Finally, open the modal
    file_frame.open();
  };

  jQuery('#hoverimagediv').on( 'click', '#upload_hover_image_button', function( event ) {
    event.preventDefault();
    jQuery.fn.upload_hover_image( jQuery(this) );
  });

  jQuery('#hoverimagediv').on( 'click', '#remove_hover_image_button', function( event ) {
    event.preventDefault();
    jQuery( '#upload_hover_image' ).val( '' );
    jQuery( '#hoverimagediv img' ).attr( 'src', '' );
    jQuery( '#hoverimagediv img' ).hide();
    jQuery( this ).attr( 'id', 'upload_hover_image_button' );
    jQuery( '#upload_hover_image_button' ).text( 'Set hover image' );
  });


  // VIDEO HOVER METABOX
  var video_file_frame;

  jQuery.fn.upload_hover_video = function( button ) {
    var button_id = button.attr('id');
    var field_id = button_id.replace( '_button', '' );

    // If the media frame already exists, reopen it.
    if ( video_file_frame ) {
      video_file_frame.open();
      return;
    }

    // Create the media frame.
    video_file_frame = wp.media.frames.video_file_frame = wp.media({
      title: jQuery( this ).data( 'uploader_title' ),
      button: {
        text: jQuery( this ).data( 'uploader_button_text' ),
      },
      multiple: false
    });

    // When an video is selected, run a callback.
    video_file_frame.on( 'select', function() {
      var attachment = video_file_frame.state().get('selection').first().toJSON();
      jQuery("#"+field_id).val(attachment.id);
      jQuery("#hovervideodiv video").attr('src',attachment.url);
      jQuery( '#hovervideodiv video' ).show();
      jQuery( '#' + button_id ).attr( 'id', 'remove_hover_video_button' );
      jQuery('#remove_hover_video_button').text('Remove hover video');
      
      console.log(attachment.url)
    });



    // Finally, open the modal
    video_file_frame.open();
  };

  jQuery('#hovervideodiv').on( 'click', '#upload_hover_video_button', function( event ) {
    event.preventDefault();
    jQuery.fn.upload_hover_video( jQuery(this) );
  });

  jQuery('#hovervideodiv').on( 'click', '#remove_hover_video_button', function( event ) {
    event.preventDefault();
    jQuery( '#upload_hover_video' ).val( '' );
    jQuery( '#hovervideodiv video' ).attr( 'src', '' );
    jQuery( '#hovervideodiv video' ).hide();
    jQuery( this ).attr( 'id', 'upload_hover_video_button' );
    jQuery( '#upload_hover_video_button' ).text( 'Set hover video' );
  });

});