<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package minimalblog
 */
get_header();

?>
	<div id="primary" class="content-area">
		<main id="main" class="site-main">
			<?php
			do_action( 'minimalblog_page_column_before' );
				if ( have_posts() ) :
					/* Start the Loop */
					while ( have_posts() ) :
						the_post();
						get_template_part( 'template-parts/content', 'single' );
					endwhile;
					?>
					<div class="d-flex next-prev-link mb-5">
						<div class="col-md-6 align-self-center text-left prev-post">
							<h4><?php echo get_previous_post_link(); ?></h4>
						</div>
						<div class="col-md-6 align-self-center text-right next-post">
							<h4><?php echo get_next_post_link(); ?></h4>
						</div>
					</div>
					<div class="post-author">
						<div class="author-image">
							<?php
							echo get_avatar( get_the_author_meta( 'ID' ), 96, '', '', null );
							?>
						</div>
						<div class="author-about">
							<h4><?php echo get_the_author_meta( 'nickname' ); ?></h4>
							<p><?php echo get_the_author_meta( 'description' ); ?></p>
						</div>
					</div>
					<?php
					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
						endif;
					else :
						get_template_part( 'template-parts/content', 'none' );
					endif;
			do_action( 'minimalblog_page_column_after' ); ?>
		</main><!-- #main -->
	</div><!-- #primary -->
<?php
get_footer();
