<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package minimalblog
 */
get_header();
?>
	<section id="primary" class="content-area archive-page-section">
		<main id="main" class="site-main">
			<?php
			do_action( 'minimalblog_page_column_before' );
				if ( have_posts() ) :
					$get_blog_layout = get_theme_mod( 'blog_layout' );
					if ( 'grid' == $get_blog_layout ) {
							echo '<div class="row masonaryactive">';
					}
					/* Start the Loop */
					while ( have_posts() ) :
						the_post();
						/*
						 * Include the Post-Type-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
						 */
						$grid_column = get_theme_mod( 'grid_column', 'col-sm-6' );
						if ( $grid_column === 'col-sm-6' ) {
							$grid_column = 'col-lg-6 col-md-12';
						} elseif ( $grid_column === 'col-sm-4' ) {
							$grid_column = 'col-sm-12 col-md-6 col-lg-4';
						} elseif ( $grid_column === 'col-sm-3' ) {
							$grid_column = 'col-sm-12 col-md-6 col-lg-3';
						}
						if ( 'grid' == $get_blog_layout ) {
							echo '<div class="' . $grid_column . ' blog-grid-layout">';
						}
						get_template_part( 'template-parts/content', 'search' );
						if ( 'grid' == $get_blog_layout ) {
							echo '</div>';
						}
					endwhile;
					if ( 'grid' == $get_blog_layout ) {
							echo '</div>';
					}
					minimalblog_pagination();
				else :
					get_template_part( 'template-parts/content', 'none' );
				endif;
			do_action( 'minimalblog_page_column_after' ); ?>
		</main><!-- #main -->
	</section><!-- #primary -->
<?php
get_footer();
