<?php
/**
 * Getting Started Help Notic
 **/
function minimalblog_general_admin_notice(){
?>
<div data-dismissible="disable-done-notice-forever" class="notice notice-info minimalblog-welcome-notice">
    <div class="minimalblog-notice-wrapper">
        <div class="minimalblog-notice-inner">
            <div class="notice-thumbnail-col">
              <img src="<?php echo esc_url(get_theme_file_uri('img/minimalblog-grid.jpg'));?>" alt="<?php esc_attr_e('Author Portfolio Pro', 'minimalblog');?>">
            </div>
            <div class="notice-content-col">
              <h3>
               <?php esc_html_e('Thank you for installing the Minimalblog WordPress Theme.', 'minimalblog'); ?>
              </h3>
              <p class="notice-desc">
              <?php esc_html_e('Ready to create a minimal blog? Click the Install Starter Templates button, and you\'ll be redirected to our demo page to get started.', 'minimalblog'); ?>
              </p>
              <p>
              <a class="minimalblog-btn-get-started button button-primary minimalblog-button-padding" href="#" data-name="" data-slug="">
                <?php esc_html_e( 'Install Starter Templates', 'minimalblog' );?>
              </a>
            <a target="_blank" href="<?php echo esc_url(minimalblog_utm_url('welcome_notice'));?>" class="button button-highlight upgrade-to-pro button-primary">
                <?php esc_html_e( 'Upgrade To Pro', 'minimalblog' );?>
            </a>
            <a href="?minimalblog_notice_dismissed" style="text-decoration: none; float: right;">
              <?php esc_html_e( 'Dismiss Notice', 'minimalblog' );?>
            </a>
            </p>
            </div>
        </div>
    </div>
</div>
<?php
}

if ( isset( $_GET['minimalblog_notice_dismissed'] ) ){
   update_option('minimalblog_help_notice', 'notice_minimalblog_dismissed');
   set_transient('minimalblog_welcome_notice_dismissed_time', time(), 2 * 60 * 60);
}

add_action('admin_init', function(){
    $minimalblog_help_notice = get_option('minimalblog_help_notice', '');
    if('notice_minimalblog_dismissed' === $minimalblog_help_notice) {
        $dismissed_time = get_transient('minimalblog_welcome_notice_dismissed_time');
        if (false === $dismissed_time || time() > $dismissed_time + ( 2 * 60 * 60 )) {
            delete_option('minimalblog_notice_dismissed');
            delete_transient('minimalblog_welcome_notice_dismissed_time');
            add_action('admin_notices', 'minimalblog_general_admin_notice');
        }
    }
});

$minimalblog_help_notice = get_option('minimalblog_help_notice', '');
if (($minimalblog_help_notice != 'notice_minimalblog_dismissed' || $minimalblog_help_notice === '') ){
   add_action('admin_notices', 'minimalblog_general_admin_notice');
}

