<?php
// Typography section
Kirki::add_section( 'typography', array(
    'title'      => esc_html__( 'Typography', 'minimalblog' ),
    'priority'   => 6,
    'panel'      => 'minimalblog',
    'capability' => 'edit_theme_options',
) );

// Body typography settings
Kirki::add_field( 'minimalblog_config', [
    'type'        => 'typography',
    'settings'    => 'minimalblog_body_typography',
    'label'       => esc_html__( 'Body Typography', 'minimalblog' ),
    'section'     => 'typography',
    'default'     => [
        'font-family'    => 'Roboto',
        'variant'        => '400',
        'font-size'      => '15px',
        'line-height'    => '1.75',
        'letter-spacing' => '0',
        'text-transform' => 'none',
    ],
    'priority'    => 10,
    'choices'     => [
        'fonts' => [
            'google' => [
                'popularity',
            ],
        ],
    ],
] );

// Body Layout radio control
Kirki::add_field( 'minimalblog_config', [
    'type'        => 'select',
    'settings'    => 'minimalblog_body_layout',
    'label'       => esc_html__( 'Body Layout', 'minimalblog' ),
    'section'     => 'typography',
    'default'     => 'fluid',
    'choices'     => [
        'box'   => esc_html__( 'Box Layout', 'minimalblog' ),
        'fluid' => esc_html__( 'Fluid Layout', 'minimalblog' ),
    ],
] );
