<?php

// Social Links Section
Kirki::add_section( 'social_links', array(
    'title'       => esc_html__( 'Social Links', 'minimalblog' ),
    'description' => esc_html__( 'Social Links. To disable social Icon keep the fields empty.', 'minimalblog' ),
    'priority'    => 2,
    'panel'       => 'minimalblog',
    'capability'  => 'edit_theme_options',
) );

// Social Links Fields
$social_links = array(
    'facebook'    => esc_html__( 'Facebook Link', 'minimalblog' ),
    'twitter'     => esc_html__( 'Twitter Link', 'minimalblog' ),
    'pinterest'   => esc_html__( 'Pinterest Link', 'minimalblog' ),
    'youtube'     => esc_html__( 'YouTube Link', 'minimalblog' ),
    'googleplus'  => esc_html__( 'Google Plus Link', 'minimalblog' ),
    'linkedin'    => esc_html__( 'LinkedIn Link', 'minimalblog' ),
    'instagram'   => esc_html__( 'Instagram Link', 'minimalblog' ),
    'github'      => esc_html__( 'GitHub Link', 'minimalblog' ),
    'stumbleupon' => esc_html__( 'StumbleUpon Link', 'minimalblog' ),
    'tumblr'      => esc_html__( 'Tumblr Link', 'minimalblog' ),
    'WordPress'   => esc_html__( 'WordPress Link', 'minimalblog' ),
    'weixin'      => esc_html__( 'Weixin Link', 'minimalblog' ),
    'snapchat'    => esc_html__( 'Snapchat Link', 'minimalblog' ),
    'qq'          => esc_html__( 'QQ Link', 'minimalblog' ),
    'reddit'      => esc_html__( 'Reddit Link', 'minimalblog' ),
);

foreach ( $social_links as $key => $label ) {
    Kirki::add_field( 'minimalblog_config', [
        'type'        => 'url',
        'settings'    => $key,
        'label'       => $label,
        'section'     => 'social_links',
        'default'     => '',
        'sanitize_callback' => 'esc_url_raw',
    ] );
}
