<?php
Kirki::add_section( 'featured_section', array(
    'title'          => esc_html__( 'Featured Section', 'minimalblog' ),
    'panel'          => 'minimalblog',
    'capability'     => 'edit_theme_options',
    'priority'       => 3,
) );

Kirki::add_field( 'minimalblog_config', [
    'type'        => 'toggle',
    'settings'    => 'featured_section_on_off',
    'label'       => esc_html__( 'Featured Section On//Off', 'minimalblog' ),
    'section'     => 'featured_section',
    'default'     => '0',
] );

Kirki::add_field( 'minimalblog_config', [
	'type'        => 'select',
	'settings'    => 'featured_categories',
	'label'       => esc_html__( 'Select Categories', 'minimalblog' ),
	'section'     => 'featured_section',
	'multiple'    => 2,
	'choices'     => minimalblog_get_categories(),
] );

Kirki::add_field( 'minimalblog_config', [
	'type'        => 'number',
	'settings'    => 'featured_post_per_page',
	'label'       => esc_html__( 'Post Per Page', 'minimalblog' ),
	'section'     => 'featured_section',
	'default'    => 2,
] );
Kirki::add_field( 'minimalblog_config', [
	'type'        => 'number',
	'settings'    => 'featured_slider_item',
	'label'       => esc_html__( 'Slide to Show', 'minimalblog' ),
	'section'     => 'featured_section',
	'default'    => 2,
] );

Kirki::add_field( 'minimalblog_config', [
	'type'        => 'select',
	'settings'    => 'featured_align',
	'label'       => esc_html__( 'Text Align', 'minimalblog' ),
	'section'     => 'featured_section',
	'default'     => 'no',
	'multiple'    => 1,
	'choices'     => [
		'left' => __( 'Left', 'minimalblog' ),
		'center' => __( 'Center', 'minimalblog' ),
		'right' => __( 'Right', 'minimalblog' ),
	],
] );
Kirki::add_field( 'minimalblog_config', [
    'type'        => 'toggle',
    'settings'    => 'featured_slider_auto_play',
    'label'       => esc_html__( 'Auto Play', 'minimalblog' ),
    'section'     => 'featured_section',
    'default'     => '0',
] );

Kirki::add_field( 'minimalblog_config', [
    'type'        => 'text',
    'settings'    => 'featured_read_more_text',
    'label'       => esc_html__( 'Read More Text', 'minimalblog' ),
    'section'     => 'featured_section',
    'default'    => __( 'Read More', 'minimalblog' ),
] );