<?php
// Add Contact Page Section
Kirki::add_section( 'contact_page_options', array(
	'title'       => __( 'Contact Page', 'minimalblog' ),
	'panel'       => 'minimalblog',
	'priority'    => 9,
	'capability'  => 'edit_theme_options',
) );

// Form Title
Kirki::add_field( 'minimalblog', array(
	'type'        => 'textarea',
	'settings'    => 'form_title',
	'label'       => __( 'Form Title', 'minimalblog' ),
	'section'     => 'contact_page_options',
	'default'     => __( 'GET A CALL BACK', 'minimalblog' ),
	'transport'   => 'refresh',
	'capability'  => 'edit_theme_options',
	'sanitize_callback' => 'wp_kses_post',
) );

// Contact Form Shortcode
Kirki::add_field( 'minimalblog', array(
	'type'        => 'textarea',
	'settings'    => 'contact_form',
	'label'       => __( 'Contact Form Shortcode', 'minimalblog' ),
	'section'     => 'contact_page_options',
	'default'     => __( 'Contact Form', 'minimalblog' ),
	'transport'   => 'refresh',
	'capability'  => 'edit_theme_options',
	'sanitize_callback' => 'wp_kses_post',
) );

// Address Title
Kirki::add_field( 'minimalblog', array(
	'type'        => 'textarea',
	'settings'    => 'address_title',
	'label'       => __( 'Address Title', 'minimalblog' ),
	'section'     => 'contact_page_options',
	'default'     => __( 'GET IN TOUCH', 'minimalblog' ),
	'transport'   => 'refresh',
	'capability'  => 'edit_theme_options',
	'sanitize_callback' => 'wp_kses_post',
) );

// Phone Number
Kirki::add_field( 'minimalblog', array(
	'type'        => 'textarea',
	'settings'    => 'phone_number',
	'label'       => __( 'Phone Number', 'minimalblog' ),
	'section'     => 'contact_page_options',
	'default'     => __( '8801793293791', 'minimalblog' ),
	'transport'   => 'refresh',
	'capability'  => 'edit_theme_options',
	'sanitize_callback' => 'wp_kses_post',
) );

// Email Address
Kirki::add_field( 'minimalblog', array(
	'type'        => 'textarea',
	'settings'    => 'email_address',
	'label'       => __( 'Email Address', 'minimalblog' ),
	'section'     => 'contact_page_options',
	'default'     => __( 'tfthemecafe@gmail.com', 'minimalblog' ),
	'transport'   => 'refresh',
	'capability'  => 'edit_theme_options',
	'sanitize_callback' => 'wp_kses_post',
) );

// Address
Kirki::add_field( 'minimalblog', array(
	'type'        => 'textarea',
	'settings'    => 'location',
	'label'       => __( 'Address', 'minimalblog' ),
	'section'     => 'contact_page_options',
	'default'     => __( '3214 Spruce Drive <br>Wexford, PA 15090', 'minimalblog' ),
	'transport'   => 'refresh',
	'capability'  => 'edit_theme_options',
	'sanitize_callback' => 'wp_kses_post',
) );

// Map API Key
Kirki::add_field( 'minimalblog', array(
	'type'        => 'textarea',
	'settings'    => 'map_api_key',
	'label'       => __( 'Map API Key', 'minimalblog' ),
	'section'     => 'contact_page_options',
	'default'     => 'AIzaSyCn4uayw359fjMh4P9i2rKKZYHzXaqTRNs',
	'transport'   => 'refresh',
	'capability'  => 'edit_theme_options',
	'sanitize_callback' => 'esc_html',
) );

// Latitude
Kirki::add_field( 'minimalblog', array(
	'type'        => 'textarea',
	'settings'    => 'latitude',
	'label'       => __( 'Latitude', 'minimalblog' ),
	'section'     => 'contact_page_options',
	'default'     => '23.706333',
	'transport'   => 'refresh',
	'capability'  => 'edit_theme_options',
	'sanitize_callback' => 'esc_html',
) );

// Longitude
Kirki::add_field( 'minimalblog', array(
	'type'        => 'textarea',
	'settings'    => 'longitude',
	'label'       => __( 'Longitude', 'minimalblog' ),
	'section'     => 'contact_page_options',
	'default'     => '90.4932206',
	'transport'   => 'refresh',
	'capability'  => 'edit_theme_options',
	'sanitize_callback' => 'esc_html',
) );