<?php

// Blog & Archive Options
Kirki::add_section( 'blog_page_settings', array(
    'title'       => esc_html__( 'Blog & Archive Options', 'minimalblog' ),
    'panel'       => 'minimalblog',
    'priority'    => 6,
) );


Kirki::add_field( 'minimalblog_config', array(
    'type'        => 'select',
    'settings'    => 'blog_page_sidebar',
    'label'       => esc_html__( 'Blog Sidebar', 'minimalblog' ),
    'section'     => 'blog_page_settings',
    'default'     => 'right',
    'choices'     => array(
        'left'  => esc_html__( 'Left Sidebar', 'minimalblog' ),
        'right' => esc_html__( 'Right Sidebar', 'minimalblog' ),
        'no'    => esc_html__( 'No Sidebar', 'minimalblog' ),
    ),

) );

Kirki::add_field( 'minimalblog_config', array(
    'type'        => 'checkbox',
    'settings'    => 'sticky_sidebar',
    'label'       => esc_html__( 'Sticky Sidebar On/Off', 'minimalblog' ),
    'section'     => 'blog_page_settings',
    'default'     => false,

) );


Kirki::add_field( 'minimalblog_config', array(
    'type'        => 'select',
    'settings'    => 'blog_layout',
    'label'       => esc_html__( 'Posts Layout', 'minimalblog' ),
    'section'     => 'blog_page_settings',
    'default'     => 'list',
    'choices'     => array(
        'grid' => esc_html__( 'Grid', 'minimalblog' ),
        'list' => esc_html__( 'List', 'minimalblog' ),
    ),

) );

Kirki::add_field( 'minimalblog_config', array(
    'type'        => 'select',
    'settings'    => 'grid_column',
    'label'       => esc_html__( 'Grid Column', 'minimalblog' ),
    'section'     => 'blog_page_settings',
    'default'     => 'col-sm-6',
    'choices'     => array(
        'col-sm-3' => esc_html__( '4 Column', 'minimalblog' ),
        'col-sm-4' => esc_html__( '3 Column', 'minimalblog' ),
        'col-sm-6' => esc_html__( '2 Column', 'minimalblog' ),
    ),
    'active_callback' => 'minimalblog_blog_grid',

) );

Kirki::add_field( 'minimalblog_config', array(
    'type'        => 'select',
    'settings'    => 'article_heading_tag',
    'label'       => esc_html__( 'Article Title Tag', 'minimalblog' ),
    'section'     => 'blog_page_settings',
    'default'     => 'h2',
    'choices'     => array(
        'h1' => esc_html__( 'h1', 'minimalblog' ),
        'h2' => esc_html__( 'h2', 'minimalblog' ),
        'h3' => esc_html__( 'h3', 'minimalblog' ),
        'h4' => esc_html__( 'h4', 'minimalblog' ),
        'h5' => esc_html__( 'h5', 'minimalblog' ),
        'h6' => esc_html__( 'h6', 'minimalblog' ),
    ),

) );

Kirki::add_field( 'minimalblog_config', array(
    'type'        => 'select',
    'settings'    => 'article_alignment',
    'label'       => esc_html__( 'Article Alignment', 'minimalblog' ),
    'section'     => 'blog_page_settings',
    'default'     => 'left',
    'choices'     => array(
        'left'   => esc_html__( 'Left', 'minimalblog' ),
        'right'  => esc_html__( 'Right', 'minimalblog' ),
        'center' => esc_html__( 'Center', 'minimalblog' ),
    ),

) );

Kirki::add_field( 'minimalblog_config', array(
    'type'        => 'number',
    'settings'    => 'excerpt_length',
    'label'       => esc_html__( 'Excerpt Length', 'minimalblog' ),
    'section'     => 'blog_page_settings',
    'default'     => 200,

) );

Kirki::add_field( 'minimalblog_config', array(
    'type'        => 'text',
    'settings'    => 'readmore_text',
    'label'       => esc_html__( 'Read More Text', 'minimalblog' ),
    'section'     => 'blog_page_settings',
    'default'     => esc_html__( 'Read More', 'minimalblog' ),

) );

// Single Post Page Settings
Kirki::add_section( 'blog_single_page_settings', array(
    'title'       => esc_html__( 'Post Single Page', 'minimalblog' ),
    'panel'       => 'minimalblog',
    'priority'    => 5,
) );

Kirki::add_field( 'minimalblog_config', array(
    'type'        => 'select',
    'settings'    => 'blog_single_page_sidebar',
    'label'       => esc_html__( 'Sidebar', 'minimalblog' ),
    'section'     => 'blog_single_page_settings',
    'default'     => 'right',
    'choices'     => array(
        'left'  => esc_html__( 'Left Sidebar', 'minimalblog' ),
        'right' => esc_html__( 'Right Sidebar', 'minimalblog' ),
        'no'    => esc_html__( 'No Sidebar', 'minimalblog' ),
    ),
) );

