<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Minimal Blog
 */
/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function minimalblog_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}
	$classes[] = 'preloader-wrapper';
	$get_border_box_shadow = get_theme_mod( 'border_box_shadow_show_hide', true );
	if ( false == $get_border_box_shadow ) {
		$classes[] = 'border_and_box_shadow_hide';
	}
	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}
	return $classes;
}
add_filter( 'body_class', 'minimalblog_body_classes' );
/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function minimalblog_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'minimalblog_pingback_header' );
if ( ! function_exists( 'minimalblog_comment_list' ) ) :
	/**
	 * Template for comments and pingbacks.
	 *
	 * Used as a callback by wp_list_comments() for displaying the comments.
	 *
	 * @since Shape 1.0
	 */
	function minimalblog_comment_list( $comment, $args, $depth ) {
		extract( $args, EXTR_SKIP );
		if ( 'div' == $args['style'] ) {
			$tag = 'div';
			$add_below = 'comment';
		} else {
			$tag = 'li';
			$add_below = 'div-comment';
		}
		?>
  <<?php echo esc_attr( $tag ); ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ); ?> id="comment-<?php comment_ID(); ?>">
		<?php if ( 'div' == $args['style'] ) : ?>
  <div id="div-comment-<?php comment_ID(); ?>" class="comment-body review-list">
	<?php endif; ?>
	<div class="single-comment">
		<div class="commenter-image">
			<?php
			if ( 0 != $args['avatar_size'] ) {
				echo get_avatar( $comment, $args['avatar_size'] );}
			?>
		</div>
		<div class="commnenter-details">
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<em><?php esc_html_e( 'Your comment is awaiting moderation.', 'minimalblog' ); ?></em>
			<br />
		<?php endif; ?>
			<h4><?php printf( wp_kses_post( '%s', 'minimalblog' ), sprintf( '%s', get_comment_author_link() ) ); ?></h4>
			<div class="comment-time">
				<p><time datetime="<?php comment_time( 'c' ); ?>">
								<?php
									/* translators: 1: comment date, 2: comment time */
									printf( wp_kses_post( '%1$s at %2$s', 'minimalblog' ), get_comment_date( '', $comment ), get_comment_time() );
								?>
							</time></p>
			</div>
				<?php comment_text(); ?>
				<?php
				comment_reply_link(
					array_merge(
						$args,
						array(
							'depth'     => $depth,
							'max_depth' => $args['max_depth'],
							'before'    => '<div class="reply">',
							'after'     => '</div>',
						)
					)
				);
				?>
		</div>
	</div>
		<?php if ( 'div' == $args['style'] ) : ?>
  </div>
			<?php
  endif;
	}
endif; // ends check for minimalblog_comment_list()
function minimalblog_user_meta( $usermeta ) {
	$usermeta['facebook'] = __( 'Facebook', 'minimalblog' );
	$usermeta['twitter'] = __( 'Twitter', 'minimalblog' );
	$usermeta['linkedin'] = __( 'Linkedin', 'minimalblog' );
	$usermeta['youtube'] = __( 'Youtube', 'minimalblog' );
	return $usermeta;
}

function minimalblog_get_excerpt( $limit, $source = null ) {
	( $source == 'content' ? ( $excerpt = get_the_content() ) : ( $excerpt = get_the_excerpt() ) );
	$excerpt = preg_replace( ' (\[.*?\])', '', $excerpt );
	$excerpt = strip_shortcodes( $excerpt );
	$excerpt = strip_tags( $excerpt );
	$excerpt = substr( $excerpt, 0, $limit );
	$excerpt = substr( $excerpt, 0, strripos( $excerpt, ' ' ) );
	$excerpt = trim( preg_replace( '/\s+/', ' ', $excerpt ) );
	return $excerpt;
}
if ( ! function_exists( 'minimalblog_footer_credit' ) ) {
	function minimalblog_footer_credit() {
		$credit = '<strong>&nbsp;&nbsp;</strong>'.esc_html__('Theme By ', 'minimalblog').'<a href="'.esc_url( 'https://www.graphicxtreme.com/' ).'"> '.esc_html__( 'Graphicxtreme', 'minimalblog' ).'</span></a>';
		return $credit;
	}
}
function minimalblog_author_vcard() {
	?>
	<div class="author-vcard">
		<div class="author-vcard__image">
			<?php
			echo get_avatar( get_the_author_meta( 'ID' ), 100, '', '', null );
			?>
		</div>
		<div class="author-vcard__about">
			<h4>
			<?php
			$desc = get_the_author_meta( 'description' );
			 echo get_the_author_meta( 'nickname' );
			?>
			 </h4>
			<?php if ( ! empty( $desc ) ) : ?>
				<p><?php echo wp_kses_post( $desc ); ?></p>
			<?php endif; ?>

			<p>
			<?php
			$userpost_count = count_user_posts( get_the_author_meta( 'ID' ), 'post', false );
			if ( $userpost_count > 1 ) {
				$numberingtext = 'posts';
			} else {
				$numberingtext = 'post';
			}
			$userposts = 'the user has only %1$s %2$s';
			printf( esc_html( $userposts ), $userpost_count, $numberingtext );
			?>
			 </p>
		</div>
	</div>
	<?php
	return;
}



/*
 * Minimalblog Page Sidebar Control
 */
add_action('minimalblog_page_column_before', 'minimalblog_page_column_wrapper_start');
function minimalblog_page_column_wrapper_start(){
	if (is_single()) {
		$minimalblog_get_sidebar_align = get_theme_mod( 'blog_single_page_sidebar', 'right' );
	}else{
		$minimalblog_get_sidebar_align = get_theme_mod( 'blog_page_sidebar', 'right' );
	}
	$minimalblog_page_content_col = 'col-md-7 col-lg-8 order-0';
	if ( $minimalblog_get_sidebar_align === 'right' ) {
		$minimalblog_page_content_col = 'col-md-7 col-lg-8 order-0';
	} elseif ( $minimalblog_get_sidebar_align === 'left' ) {
		$minimalblog_page_content_col = 'col-md-7 col-lg-8 order-1';
	} elseif ( $minimalblog_get_sidebar_align === 'no' ) {
		$minimalblog_page_content_col = 'col-md-12';
	} else {
		$minimalblog_page_content_col = 'col-md-7 col-lg-8 order-0';
	}

	?>
	<div class="container">
		<div class="row wrapper-content">
			<div class="<?php echo esc_attr( $minimalblog_page_content_col ); ?>">
	<?php
}

add_action('minimalblog_page_column_after', 'minimalblog_page_column_wrapper_end');
function minimalblog_page_column_wrapper_end(){
	if (is_single()) {
		$minimalblog_get_sidebar_align = get_theme_mod( 'blog_single_page_sidebar', 'right' );
	}else{
		$minimalblog_get_sidebar_align = get_theme_mod( 'blog_page_sidebar', 'right' );
	}
	$minimalblog_page_sidebar_col = 'col-md-5 col-lg-4 order-1';
	$minimalblog_page_sidebar_on_off = true;
	if ( $minimalblog_get_sidebar_align === 'right' ) {
		$minimalblog_page_sidebar_col = 'col-md-5 col-lg-4 order-1';
		$minimalblog_page_sidebar_on_off = true;
	} elseif ( $minimalblog_get_sidebar_align === 'left' ) {
		$minimalblog_page_sidebar_col = 'col-md-5 col-lg-4 order-0';
		$minimalblog_page_sidebar_on_off = true;
	} elseif ( $minimalblog_get_sidebar_align === 'no' ) {
		$minimalblog_page_sidebar_col = 'sidebar-hide';
		$minimalblog_page_sidebar_on_off = false;
	} else {
		$minimalblog_page_sidebar_col = 'col-md-5 col-lg-4 order-1';
	}
	?>
			</div>
			<?php if ( $minimalblog_page_sidebar_on_off === true ) : ?>
				<div class="<?php echo esc_attr( $minimalblog_page_sidebar_col ); ?>">
						<?php get_sidebar(); ?>
				</div>
			<?php endif; ?>
		</div>
	</div>
	<?php
}
function minimalblog_utm_url($medium){
    $rawUrl = sprintf(
        'https://rswpthemes.com/author-blog-pro-wordpress-theme/?utm_source=free_theme&utm_medium=%s&utm_campaign=minimalblog',
        rawurlencode($medium)
    );
    return $rawUrl;
}

function minimalblog_social_links(){
	$facebook = get_theme_mod( 'facebook' );
	$twitter = get_theme_mod( 'twitter' );
	$googleplus = get_theme_mod( 'googleplus' );
	$pinterest = get_theme_mod( 'pinterest' );
	$youtube = get_theme_mod( 'youtube' );
	$instagram = get_theme_mod( 'instagram' );
	$github = get_theme_mod( 'github' );
	$stumbleupon = get_theme_mod( 'stumbleupon' );
	$tumblr = get_theme_mod( 'tumblr' );
	$wordpress = get_theme_mod( 'WordPress' );
	$weixin = get_theme_mod( 'weixin' );
	$snapchat = get_theme_mod( 'snapchat' );
	$qq = get_theme_mod( 'qq' );
	$reddit = get_theme_mod( 'reddit' );
	$linkedin = get_theme_mod( 'linkedin' );
	if ( ! empty( $facebook ) ) :
	?>
	<a target="_blank" href="<?php echo esc_url( $facebook ); ?>" class="fa fa-facebook"></a>
	<?php endif; if ( ! empty( $twitter ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $twitter ); ?>" class="fa fa-twitter"></a>
	<?php endif; if ( ! empty( $googleplus ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $googleplus ); ?>" class="fa fa-google-plus"></a>
	<?php endif; if ( ! empty( $pinterest ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $pinterest ); ?>" class="fa fa-pinterest"></a>
	<?php endif; if ( ! empty( $youtube ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $youtube ); ?>" class="fa fa-youtube"></a>
	<?php endif; if ( ! empty( $linkedin ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $linkedin ); ?>" class="fa fa-linkedin"></a>
	<?php endif; if ( ! empty( $instagram ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $instagram ); ?>" class="fa fa-instagram"></a>
	<?php endif; if ( ! empty( $github ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $github ); ?>" class="fa fa-github"></a>
	<?php endif; if ( ! empty( $stumbleupon ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $stumbleupon ); ?>" class="fa fa-stumbleupon"></a>
	<?php endif; if ( ! empty( $tumblr ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $tumblr ); ?>" class="fa fa-tumblr"></a>
	<?php endif; if ( ! empty( $wordpress ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $wordpress ); ?>" class="fa fa-wordpress"></a>
	<?php endif; if ( ! empty( $weixin ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $weixin ); ?>" class="fa fa-weixin"></a>
	<?php endif; if ( ! empty( $snapchat ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $snapchat ); ?>" class="fa fa-snapchat"></a>
	<?php endif; if ( ! empty( $qq ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $qq ); ?>" class="fa fa-qq"></a>
	<?php endif; if ( ! empty( $reddit ) ) : ?>
	<a target="_blank" href="<?php echo esc_url( $reddit ); ?>" class="fa fa-reddit"></a>
	<?php endif;
}