<?php
/**
 * Getting Started Page.
 *
 * @package minimalblog
 */


$minimalblog_theme = wp_get_theme();
$minimalblog_version = $minimalblog_theme->get('Version');
$minimalblog_name = $minimalblog_theme->get('Name');

define('MINIMALBLOG_THEME_VERSION', $minimalblog_version);
define('MINIMALBLOG_THEME_NAME', $minimalblog_name);
require get_template_directory() . '/inc/getting-started/class-getting-start-plugin-helper.php';

if( ! function_exists( 'minimalblog_getting_started_admin_scripts' ) ) :
/**
 * Load Getting Started styles in the admin
 */
function minimalblog_getting_started_admin_scripts( $hook ){
    wp_enqueue_style( 'minimalblog-focus', get_template_directory_uri() . '/inc/getting-started/css/focus.css', false, MINIMALBLOG_THEME_VERSION );
	// Load styles only on our page
	if( 'appearance_page_minimalblog-getting-started' != $hook ) return;

    wp_enqueue_style( 'minimalblog-getting-started', get_template_directory_uri() . '/inc/getting-started/css/getting-started.css', false, MINIMALBLOG_THEME_VERSION );
    
    wp_enqueue_script( 'plugin-install' );
    wp_enqueue_script( 'updates' );
    wp_enqueue_script( 'minimalblog-getting-started', get_template_directory_uri() . '/inc/getting-started/js/getting-started.js', array( 'jquery' ), MINIMALBLOG_THEME_VERSION, true );
    wp_enqueue_script( 'minimalblog-recommended-plugin-install', get_template_directory_uri() . '/inc/getting-started/js/recommended-plugin-install.js', array( 'jquery' ), MINIMALBLOG_THEME_VERSION, true );    
    wp_localize_script( 'minimalblog-recommended-plugin-install', 'minimalblog_start_page', array( 'activating' => __( 'Activating ', 'minimalblog' ) ) );
}
endif;
add_action( 'admin_enqueue_scripts', 'minimalblog_getting_started_admin_scripts' );

if( ! function_exists( 'minimalblog_call_plugin_api' ) ) :
/**
 * Plugin API
**/
function minimalblog_call_plugin_api( $plugin ) {
	include_once ABSPATH . 'wp-admin/includes/plugin-install.php';
	$call_api = plugins_api( 
        'plugin_information', 
            array(
    		'slug'   => $plugin,
    		'fields' => array(
    			'downloaded'        => false,
    			'rating'            => false,
    			'description'       => false,
    			'short_description' => true,
    			'donate_link'       => false,
    			'tags'              => false,
    			'sections'          => true,
    			'homepage'          => true,
    			'added'             => false,
    			'last_updated'      => false,
    			'compatibility'     => false,
    			'tested'            => false,
    			'requires'          => false,
    			'downloadlink'      => false,
    			'icons'             => true
    		)
    	) 
    );
	return $call_api;
}
endif;

if( ! function_exists( 'minimalblog_check_for_icon' ) ) :
/**
 * Check For Icon 
**/
function minimalblog_check_for_icon( $arr ) {
	if( ! empty( $arr['svg'] ) ){
		$plugin_icon_url = $arr['svg'];
	}elseif( ! empty( $arr['2x'] ) ){
		$plugin_icon_url = $arr['2x'];
	}elseif( ! empty( $arr['1x'] ) ){
		$plugin_icon_url = $arr['1x'];
	}else{
		$plugin_icon_url = $arr['default'];
	}                               
	return $plugin_icon_url;
}
endif;