<?php
/**
 * Sidebar Metabox.
 *
 * @package Minimal Blog
 */

// Register metaboxes after init to avoid early translation issues
if( ! function_exists( 'minimal_blog_metabox' ) ):
    function minimal_blog_metabox() {
        add_meta_box(
            'theme-custom-metabox',
            __( 'Layout Settings', 'minimal-blog' ),
            'minimal_blog_post_metafield_callback',
            'post',
            'normal',
            'high'
        );

        add_meta_box(
            'theme-custom-metabox',
            __( 'Layout Settings', 'minimal-blog' ),
            'minimal_blog_post_metafield_callback',
            'page',
            'normal',
            'high'
        );
    }
endif;

add_action( 'init', function() {
    add_action( 'add_meta_boxes', 'minimal_blog_metabox' );
});

/**
 * Return sidebar layout options.
 */
function minimal_blog_get_sidebar_fields() {
    return array(
        'global-sidebar' => array(
            'value' => 'global-sidebar',
            'label' => esc_html__( 'Global sidebar', 'minimal-blog' ),
        ),
        'sidebar-right' => array(
            'value' => 'sidebar-right',
            'label' => esc_html__( 'Right sidebar', 'minimal-blog' ),
        ),
        'sidebar-left' => array(
            'value' => 'sidebar-left',
            'label' => esc_html__( 'Left sidebar', 'minimal-blog' ),
        ),
        'no-sidebar' => array(
            'value' => 'no-sidebar',
            'label' => esc_html__( 'Full Width', 'minimal-blog' ),
        ),
    );
}


/**
 * Callback function for post options.
 */
if( ! function_exists( 'minimal_blog_post_metafield_callback' ) ):

    function minimal_blog_post_metafield_callback() {
        global $post;
        $minimal_blog_post_sidebar_fields = minimal_blog_get_sidebar_fields();
        $post_type = get_post_type($post->ID);
        $ut_ed_twitter_summary = get_theme_mod('ut_ed_twitter_summary');
        $ut_ed_open_graph = get_theme_mod('ut_ed_open_graph');
        wp_nonce_field( basename( __FILE__ ), 'minimal_blog_post_meta_nonce' ); ?>

        <div class="metabox-main-block">
            <div class="metabox-navbar">
                <ul>
                    <li>
                        <a id="metabox-navbar-general" class="metabox-navbar-active" href="javascript:void(0)">
                            <?php esc_html_e('Appearance Settings', 'minimal-blog'); ?>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="theme-tab-content">
                <div id="metabox-navbar-general-content" class="metabox-content-wrap metabox-content-wrap-active">
                    <div class="metabox-opt-panel">
                        <h3 class="meta-opt-title"><?php esc_html_e('Sidebar Layout','minimal-blog'); ?></h3>
                        <div class="metabox-opt-wrap metabox-opt-wrap-alt">
                            <?php
                            $minimal_blog_post_sidebar = esc_html( get_post_meta( $post->ID, 'minimal_blog_post_sidebar_option', true ) );
                            if ( $minimal_blog_post_sidebar == '' ) {
                                $minimal_blog_post_sidebar = 'global-sidebar';
                            }

                            foreach ( $minimal_blog_post_sidebar_fields as $field ) { ?>
                                <label class="description">
                                    <input type="radio" name="minimal_blog_post_sidebar_option" value="<?php echo esc_attr( $field['value'] ); ?>" <?php checked( $field['value'], $minimal_blog_post_sidebar ); ?> />
                                    &nbsp;<?php echo esc_html( $field['label'] ); ?>
                                </label>
                            <?php } ?>
                        </div>
                    </div>

                    <?php $minimal_blog_ed_feature_image = esc_attr(get_post_meta($post->ID, 'minimal-blog-meta-checkbox', true)); ?>
                    <div class="metabox-opt-panel">
                        <div class="metabox-opt-wrap theme-checkbox-wrap">
                            <input id="minimal-blog-ed-feature-image" name="minimal-blog-meta-checkbox" type="checkbox" <?php checked($minimal_blog_ed_feature_image); ?> />
                            <label for="minimal-blog-ed-feature-image"><?php esc_html_e('Disable Feature Image', 'minimal-blog'); ?></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <?php }
endif;

/**
 * Save metabox values.
 */
add_action( 'save_post', 'minimal_blog_save_post_meta' );

if( ! function_exists( 'minimal_blog_save_post_meta' ) ):

    function minimal_blog_save_post_meta( $post_id ) {
        if (
            ! isset( $_POST['minimal_blog_post_meta_nonce'] ) ||
            ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['minimal_blog_post_meta_nonce'] ) ), basename( __FILE__ ) )
        ) {
            return;
        }

        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }

        if ( isset( $_POST['post_type'] ) && 'page' === $_POST['post_type'] ) {
            if ( ! current_user_can( 'edit_page', $post_id ) ) {
                return $post_id;
            }
        } elseif ( ! current_user_can( 'edit_post', $post_id ) ) {
            return $post_id;
        }

        // Save sidebar layout
        if ( isset( $_POST['minimal_blog_post_sidebar_option'] ) ) {
            $new = sanitize_text_field( $_POST['minimal_blog_post_sidebar_option'] );
            update_post_meta( $post_id, 'minimal_blog_post_sidebar_option', $new );
        }

        // Save feature image checkbox
        $checkbox = isset( $_POST['minimal-blog-meta-checkbox'] ) ? '1' : '';
        update_post_meta( $post_id, 'minimal-blog-meta-checkbox', $checkbox );
    }

endif;