<?php
/**
* Register widget area.
*
* @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
*/
function minimal_blog_widgets_init() {
    register_sidebar( array(
    'name'          => esc_html__( 'Sidebar', 'minimal-blog' ),
    'id'            => 'sidebar-1',
    'description'   => '',
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
    'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Col-1', 'minimal-blog' ),
        'id'            => 'footer-1',
        'description'   => '',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Col-2', 'minimal-blog' ),
        'id'            => 'footer-2',
        'description'   => '',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Col-3', 'minimal-blog' ),
        'id'            => 'footer-3',
        'description'   => '',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
}
add_action( 'widgets_init', 'minimal_blog_widgets_init' );

if( !function_exists( 'minimal_blog_social_menu_icon' ) ) :

    function minimal_blog_social_menu_icon( $item_output, $item, $depth, $args ) {

        // Add Icon
        if ( isset( $args->theme_location ) && 'menu-social' === $args->theme_location ) {

            $svg = Minimal_Blog_SVG_Icons::get_theme_svg_name( $item->url );

            if ( empty( $svg ) ) {
                $svg = minimal_blog_the_theme_svg( 'link',$return = true );
            }

            $item_output = str_replace( $args->link_after, '</span>' . $svg, $item_output );
        }

        return $item_output;
    }
    
endif;

add_filter( 'walker_nav_menu_start_el', 'minimal_blog_social_menu_icon', 10, 4 );


/**
 * Minimal Blog SVG Icon helper functions
 *
 * @package Minimal Blog
 * @since 1.0.0
 */
if ( ! function_exists( 'minimal_blog_the_theme_svg' ) ):
    /**
     * Output and Get Theme SVG.
     * Output and get the SVG markup for an icon in the Minimal_Blog_SVG_Icons class.
     *
     * @param string $svg_name The name of the icon.
     * @param string $group The group the icon belongs to.
     * @param string $color Color code.
     */
    function minimal_blog_the_theme_svg( $svg_name, $return = false ) {

        if( $return ){

            return minimal_blog_get_theme_svg( $svg_name ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in minimal_blog_get_theme_svg();.

        }else{

            echo minimal_blog_get_theme_svg( $svg_name ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in minimal_blog_get_theme_svg();.
            
        }
    }

endif;

if ( ! function_exists( 'minimal_blog_get_theme_svg' ) ):

    /**
     * Get information about the SVG icon.
     *
     * @param string $svg_name The name of the icon.
     * @param string $group The group the icon belongs to.
     * @param string $color Color code.
     */
    function minimal_blog_get_theme_svg( $svg_name ) {

        // Make sure that only our allowed tags and attributes are included.
        $svg = minimal_blog_svg_escape( Minimal_Blog_SVG_Icons::get_svg( $svg_name ) );
        if ( ! $svg ) {
            return false;
        }
        return $svg;

    }

endif;


if ( ! function_exists( 'minimal_blog_svg_escape' ) ):

    /**
     * Get information about the SVG icon.
     *
     * @param string $svg_name The name of the icon.
     * @param string $group The group the icon belongs to.
     * @param string $color Color code.
     */
    function minimal_blog_svg_escape( $input ) {

        // Make sure that only our allowed tags and attributes are included.
        $svg = wp_kses(
            $input,
            array(
                'svg'     => array(
                    'class'       => true,
                    'xmlns'       => true,
                    'width'       => true,
                    'height'      => true,
                    'viewbox'     => true,
                    'aria-hidden' => true,
                    'role'        => true,
                    'focusable'   => true,
                ),
                'path'    => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'd'         => true,
                    'transform' => true,
                ),
                'polygon' => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'points'    => true,
                    'transform' => true,
                    'focusable' => true,
                ),
            )
        );

        if ( ! $svg ) {
            return false;
        }

        return $svg;

    }

endif;


if( !function_exists('minimal_blog_post_format_icon') ):

    // Post Format Icon.
    function minimal_blog_post_format_icon( ){

        global $post;
        
        $format = get_post_format( $post->ID ) ? : 'standard';

        if( $format == 'video' ){
            $icon = minimal_blog_get_theme_svg( 'video' );
        }elseif( $format == 'audio' ){
            $icon = minimal_blog_get_theme_svg( 'audio' );
        }elseif( $format == 'gallery' ){
            $icon = minimal_blog_get_theme_svg( 'gallery' );
        }elseif( $format == 'quote' ){
            $icon = minimal_blog_get_theme_svg( 'quote' );
        }elseif( $format == 'image' ){
            $icon = minimal_blog_get_theme_svg( 'image' );
        }else{
            $icon = '';
        }

        if( !empty( $icon ) ){ ?>

            <span class="wpi-format-icon">
                <?php echo minimal_blog_svg_escape( $icon ); ?>
            </span>

        <?php }

    }

endif;


if (!function_exists('minimal_blog_recommended_plugins')):

    /**
     * Recommended plugins
     *
     */
    function minimal_blog_recommended_plugins() {
        $minimal_blog_plugins = array(
            array(
                'name'     => __('One Click Demo Import', 'minimal-blog'),
                'slug'     => 'one-click-demo-import',
                'required' => false,
            )
        );
        $minimal_blog_plugins_config = array(
            'dismissable' => true,
        );

        tgmpa($minimal_blog_plugins, $minimal_blog_plugins_config);
    }
endif;
add_action('tgmpa_register', 'minimal_blog_recommended_plugins');


function minimal_blog_check_other_plugin() {
	// check for plugin using plugin name
	if (is_plugin_active('one-click-demo-import/one-click-demo-import.php')) {
			// Disable PT branding.
			add_filter('pt-ocdi/disable_pt_branding', '__return_true');
			//plugin is activated
			function ocdi_after_import_setup() {
					// Assign menus to their locations.
					$main_menu   = get_term_by('name', 'Menu 1', 'nav_menu');

					set_theme_mod('nav_menu_locations', array(
									'menu-1' => $main_menu->term_id,
							)
					);

					// Assign front page and posts page (blog page).
					$front_page_id = get_page_by_title('');
					$blog_page_id  = get_page_by_title('Blog');

					update_option('show_on_front', 'page');
					update_option('page_on_front', $front_page_id->ID);
					update_option('page_for_posts', $blog_page_id->ID);

			}
			add_action('pt-ocdi/after_import', 'ocdi_after_import_setup');
	}
}
add_action('admin_init', 'minimal_blog_check_other_plugin');

if( !function_exists('minimal_blog_post_floating_nav') ):

    function minimal_blog_post_floating_nav(){

        $single_fixed_floating_nav = minimal_blog_get_option('single_fixed_floating_nav');
        if( 'post' === get_post_type() && $single_fixed_floating_nav ){

            $next_post = get_next_post();
            $prev_post = get_previous_post();

            if( isset( $prev_post->ID ) ){

                $prev_link = get_permalink( $prev_post->ID );?>

                <div class="floating-post-navigation floating-navigation-prev">

                    <?php
                    if ( get_the_post_thumbnail( $prev_post->ID, 'medium' ) ) {
                        echo get_the_post_thumbnail( $prev_post->ID, 'medium', array( 'class' => 'attachment-medium_large size-medium_large image-responsive' ) );
                    }
                    ?>

                    <a href="<?php echo esc_url( $prev_link ); ?>">
                        <span class="floating-navigation-label"><?php echo esc_html__('Previous post', 'minimal-blog'); ?></span>
                        <span class="floating-navigation-title"><?php echo esc_html( get_the_title( $prev_post->ID ) ); ?></span>
                    </a>

                </div>

            <?php }

            if( isset( $next_post->ID ) ){

                $next_link = get_permalink( $next_post->ID );?>

                <div class="floating-post-navigation floating-navigation-next">

                    <?php
                    if ( get_the_post_thumbnail( $next_post->ID, 'medium' ) ) {
                        echo get_the_post_thumbnail( $next_post->ID, 'medium', array( 'class' => 'attachment-medium_large size-medium_large image-responsive' ) );
                    }
                    ?>

                    <a href="<?php echo esc_url( $next_link ); ?>">
                        <span class="floating-navigation-label"><?php echo esc_html__('Next post', 'minimal-blog'); ?></span>
                        <span class="floating-navigation-title"><?php echo esc_html( get_the_title( $next_post->ID ) ); ?></span>
                    </a>

                </div>

                <?php
            }

        }

    }

endif;

add_action( 'minimal_blog_navigation_action','minimal_blog_post_floating_nav',10 );