<?php
/**
 * Title: Contact Us
 * Slug: mine-educn/contact-us
 * Categories: mine-educn,about
 * Description: A section with contact infos.
 */
?>
<!-- wp:group {"tagName":"section","metadata":{"name":"Contact Us","categories":["mine-educn"],"patternName":"mine-educn/ready-to-learn"},"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"elements":{"link":{"color":{"text":"var:preset|color|background"}}}},"backgroundColor":"main-2","textColor":"background","layout":{"type":"default"}} -->
<section class="wp-block-group has-background-color has-main-2-background-color has-text-color has-background has-link-color" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)">
<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull">
<!-- wp:group {"align":"wide","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between","verticalAlignment":"stretch","orientation":"horizontal"}} -->
<div class="wp-block-group alignwide">
<!-- wp:group {"className":"tw-flex-1","style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"}},"border":{"radius":"10px"}},"backgroundColor":"background","layout":{"type":"constrained","justifyContent":"center","contentSize":""}} -->
<div class="wp-block-group tw-flex-1 has-background-background-color has-background" style="border-radius:10px;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)">
<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group">
<!-- wp:heading {"textAlign":"left"} -->
<h2 class="wp-block-heading has-text-align-left"><?php esc_html_e('Contact Us', 'mine-educn'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left"} -->
<p class="has-text-align-left"><?php esc_html_e('We are pleased to serve you, and you may provide feedback for any questions or concerns.', 'mine-educn'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"left"} -->
<p class="has-text-align-left"><?php esc_html_e('Scan the WeChat QR code on the right, or click directly to chat via QQ.', 'mine-educn'); ?> 👉</p>
<!-- /wp:paragraph -->
</div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--60)">
<!-- wp:group {"layout":{"type":"grid","columnCount":2,"minimumColumnWidth":null}} -->
<div class="wp-block-group">
<!-- wp:paragraph {"className":"medu-icon check","style":{"layout":{"columnSpan":1,"rowSpan":1}}} -->
<p class="medu-icon check"><?php esc_html_e('Cooperation Negotiation', 'mine-educn'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"medu-icon check"} -->
<p class="medu-icon check"><?php esc_html_e('Feedback and Suggestions', 'mine-educn'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"medu-icon check","style":{"layout":{"columnSpan":1,"rowSpan":1}}} -->
<p class="medu-icon check"><?php esc_html_e('Customized Courses', 'mine-educn'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"medu-icon check","style":{"layout":{"columnSpan":1,"rowSpan":1}}} -->
<p class="medu-icon check"><?php esc_html_e('Answer Questions and Resolve Doubts', 'mine-educn'); ?></p>
<!-- /wp:paragraph -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:group -->

<!-- wp:group {"className":"tw-flex-1","style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"}},"border":{"radius":"10px"}},"backgroundColor":"background","layout":{"type":"constrained","contentSize":"100%"}} -->
<div class="wp-block-group tw-flex-1 has-background-background-color has-background" style="border-radius:10px;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)">
<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"stretch"}} -->
<div class="wp-block-group">
<!-- wp:group {"className":"tw-flex-1","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}},"border":{"radius":"10px"}},"backgroundColor":"gray-light","layout":{"type":"constrained","justifyContent":"center"}} -->
<div class="wp-block-group tw-flex-1 has-gray-light-background-color has-background" style="border-radius:10px;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)">
<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group">
<!-- wp:paragraph {"align":"center","className":"medu-icon wechat","style":{"elements":{"link":{"color":{"text":"var:preset|color|main-2"}}}},"textColor":"main-2","fontSize":"medium"} -->
<p class="has-text-align-center medu-icon wechat has-main-2-color has-text-color has-link-color has-medium-font-size"><?php esc_html_e('Contact Method', 'mine-educn'); ?> 1</p>
<!-- /wp:paragraph -->
</div>
<!-- /wp:group -->

<!-- wp:group {"layout":{"type":"constrained","justifyContent":"center"}} -->
<div class="wp-block-group">
<!-- wp:group {"layout":{"type":"constrained","contentSize":"130px"}} -->
<div class="wp-block-group">
<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|10","bottom":"var:preset|spacing|10","left":"var:preset|spacing|10","right":"var:preset|spacing|10"}},"border":{"radius":"10px"}},"backgroundColor":"background","layout":{"type":"constrained","contentSize":""}} -->
<div class="wp-block-group has-background-background-color has-background" style="border-radius:10px;padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)">
<!-- wp:image {"id":2512,"width":"110px","height":"110px","scale":"cover","sizeSlug":"medium","linkDestination":"none","align":"center"} -->
<figure class="wp-block-image aligncenter size-medium is-resized"><img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/homeschooling.jpg" alt="" class="wp-image-2512" style="object-fit:cover;width:110px;height:110px"/></figure>
<!-- /wp:image -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:group -->

<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|font"}}}},"textColor":"font","fontSize":"x-small"} -->
<p class="has-text-align-center has-font-color has-text-color has-link-color has-x-small-font-size"><strong><?php esc_html_e('Scan the WeChat ID above: MineCloudVod', 'mine-educn'); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","fontSize":"x-small"} -->
<p class="has-text-align-center has-x-small-font-size"><?php esc_html_e('Consult the 24/7 online customer service', 'mine-educn'); ?></p>
<!-- /wp:paragraph -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:group -->

<!-- wp:group {"className":"tw-flex-1","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}},"border":{"radius":"10px"}},"backgroundColor":"gray-light","layout":{"type":"constrained","justifyContent":"center"}} -->
<div class="wp-block-group tw-flex-1 has-gray-light-background-color has-background" style="border-radius:10px;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)">
<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group">
<!-- wp:paragraph {"align":"center","className":"medu-icon qq","style":{"elements":{"link":{"color":{"text":"var:preset|color|main-2"}}}},"textColor":"main-2","fontSize":"medium"} -->
<p class="has-text-align-center medu-icon qq has-main-2-color has-text-color has-link-color has-medium-font-size"><?php esc_html_e('Contact Method', 'mine-educn'); ?> 2</p>
<!-- /wp:paragraph -->
</div>
<!-- /wp:group -->

<!-- wp:group {"layout":{"type":"constrained","justifyContent":"center"}} -->
<div class="wp-block-group">
<!-- wp:group {"align":"wide","layout":{"type":"constrained","contentSize":"130px"}} -->
<div class="wp-block-group alignwide">
<!-- wp:group {"align":"wide","style":{"dimensions":{"minHeight":"130px"},"spacing":{"padding":{"right":"0","left":"0","top":"var:preset|spacing|20","bottom":"0"}},"border":{"radius":"10px"}},"backgroundColor":"background","layout":{"type":"default"}} -->
<div class="wp-block-group alignwide has-background-background-color has-background" style="border-radius:10px;min-height:130px;padding-top:var(--wp--preset--spacing--20);padding-right:0;padding-bottom:0;padding-left:0">
<!-- wp:image {"height":"44px","width":"44px","sizeSlug":"thumbnail","linkDestination":"none","align":"center"} -->
<figure class="wp-block-image aligncenter size-thumbnail is-resized"><img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/homeschooling.jpg" alt="" style="width:44px;height:44px;"/></figure>
<!-- /wp:image -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons">
<!-- wp:button {"backgroundColor":"main-2","style":{"spacing":{"padding":{"left":"var:preset|spacing|40","right":"var:preset|spacing|40","top":"var:preset|spacing|10","bottom":"var:preset|spacing|10"}}},"fontSize":"x-small"} -->
<div class="wp-block-button"><a class="wp-block-button__link has-main-2-background-color has-background has-x-small-font-size has-custom-font-size wp-element-button" style="padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--40)"><?php esc_html_e('Click to Chat', 'mine-educn'); ?></a></div>
<!-- /wp:button -->
</div>
<!-- /wp:buttons -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:group -->

<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|font"}}}},"textColor":"font","fontSize":"x-small"} -->
<p class="has-text-align-center has-font-color has-text-color has-link-color has-x-small-font-size"><strong>QQ: </strong><em>995525477</em></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","fontSize":"x-small"} -->
<p class="has-text-align-center has-x-small-font-size"><?php esc_html_e('Please state your purpose when adding a friend.', 'mine-educn'); ?></p>
<!-- /wp:paragraph -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:group -->
</section>
<!-- /wp:group -->