<?php
/**
 * Title: Carousel Banner
 * Slug: mine-educn/carousel-banner
 * Categories: mine-educn,banner
 * Description: A carousel banner with text and image.
 */
?>
<!-- wp:group {"tagName":"section","metadata":{"name":"<?php esc_html_e('Carousel Banner', 'mine-educn'); ?>","categories":["banner"],"patternName":"mine-educn/carousel-banner"},"className":"medu-carousel","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"default"}} -->
<section class="wp-block-group medu-carousel" style="margin-top:0;margin-bottom:0">
<!-- wp:group {"metadata":{"name":"<?php esc_html_e('Carousel Banner Content', 'mine-educn'); ?>"},"className":"medu-carousel-content","style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"left","verticalAlignment":"stretch"}} -->
<div class="wp-block-group medu-carousel-content">
<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"right":"0","left":"0","top":"0","bottom":"0"},"blockGap":"0"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"stretch","justifyContent":"space-between"}} -->
<div class="wp-block-group alignfull" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0">
<!-- wp:cover {"isUserOverlayColor":true,"minHeightUnit":"px","gradient":"vivid-cyan-blue-to-vivid-purple","contentPosition":"center center","metadata":{"name":"<?php esc_html_e('Carousel Item', 'mine-educn'); ?>"},"align":"full","className":"medu-carousel-item tw-flex-1","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignfull medu-carousel-item tw-flex-1" style="padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--80);padding-left:var(--wp--preset--spacing--30)"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-100 has-background-dim has-background-gradient has-vivid-cyan-blue-to-vivid-purple-gradient-background"></span><div class="wp-block-cover__inner-container">
<!-- wp:columns {"verticalAlignment":"center","metadata":{"name":"<?php esc_html_e('Carousel Banner Content', 'mine-educn'); ?>"},"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|80"}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center">
<!-- wp:column {"verticalAlignment":"center","width":"50%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:50%">
<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"constrained","justifyContent":"center"}} -->
<div class="wp-block-group">
<!-- wp:heading {"level":1,"fontSize":"xx-large"} -->
<h1 class="wp-block-heading has-xx-large-font-size"><?php esc_html_e('Explore the Infinite Possibilities of Future Learning', 'mine-educn'); ?></h1>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|background"}}}},"textColor":"background"} -->
<p class="has-text-align-left has-background-color has-text-color has-link-color"><?php esc_html_e('Over 1,000 premium courses available for learning anytime, anywhere, helping you master essential skills for your future career', 'mine-educn'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"className":"tw-flex tw-flex-wrap tw-gap-4 tw-pt-4"} -->
<div class="wp-block-buttons tw-flex tw-flex-wrap tw-gap-4 tw-pt-4">
<!-- wp:button {"backgroundColor":"background","textColor":"main-2","className":"medu-btn-hover-up is-style-fill","style":{"border":{"radius":"6px","width":"1px"},"elements":{"link":{"color":{"text":"var:preset|color|main-2"}}}},"borderColor":"background"} -->
<div class="wp-block-button medu-btn-hover-up is-style-fill"><a class="wp-block-button__link has-main-2-color has-background-background-color has-text-color has-background has-link-color has-border-color has-background-border-color wp-element-button" href="#" style="border-width:1px;border-radius:6px"><?php esc_html_e('Browse Courses', 'mine-educn'); ?></a></div>
<!-- /wp:button -->

<!-- wp:button {"textColor":"background","className":"medu-btn-hover-trans is-style-outline","style":{"border":{"radius":"6px","width":"1px"},"elements":{"link":{"color":{"text":"var:preset|color|background"}}}},"borderColor":"background"} -->
<div class="wp-block-button medu-btn-hover-trans is-style-outline"><a class="wp-block-button__link has-background-color has-text-color has-link-color has-border-color has-background-border-color wp-element-button" href="#" style="border-width:1px;border-radius:6px"><?php esc_html_e('Popular Recommendations', 'mine-educn'); ?></a></div>
<!-- /wp:button -->
</div>
<!-- /wp:buttons -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"50%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:50%">
<!-- wp:group {"style":{"dimensions":{"minHeight":""}},"layout":{"type":"default"}} -->
<div class="wp-block-group">
<!-- wp:image {"id":60,"scale":"cover","sizeSlug":"full","linkDestination":"none","className":"img-left","style":{"color":{"duotone":"unset"}}} -->
<figure class="wp-block-image size-full img-left"><img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/homeschooling.jpg" alt="" class="wp-image-60" style="object-fit:cover"/></figure>
<!-- /wp:image -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:column -->
</div>
<!-- /wp:columns -->
</div></div>
<!-- /wp:cover -->

<!-- wp:cover {"isUserOverlayColor":true,"gradient":"luminous-vivid-amber-to-luminous-vivid-orange","contentPosition":"center center","metadata":{"name":"<?php esc_html_e('Carousel Item', 'mine-educn'); ?>"},"align":"full","className":"medu-carousel-item tw-flex-1","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignfull medu-carousel-item tw-flex-1" style="padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--80);padding-left:var(--wp--preset--spacing--30)"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-100 has-background-dim has-background-gradient has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background"></span><div class="wp-block-cover__inner-container">
<!-- wp:columns {"verticalAlignment":"center","metadata":{"name":"<?php esc_html_e('Carousel Banner Content', 'mine-educn'); ?>"},"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|80"}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center">
<!-- wp:column {"verticalAlignment":"center","width":"50%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:50%">
<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"constrained","justifyContent":"center"}} -->
<div class="wp-block-group">
<!-- wp:heading {"level":1,"fontSize":"xx-large"} -->
<h1 class="wp-block-heading has-xx-large-font-size"><?php esc_html_e('Explore the Infinite Possibilities of Future Learning', 'mine-educn'); ?></h1>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|background"}}}},"textColor":"background"} -->
<p class="has-text-align-left has-background-color has-text-color has-link-color"><?php esc_html_e('Over 1,000 premium courses available for learning anytime, anywhere, helping you master essential skills for your future career', 'mine-educn'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"className":"tw-flex tw-flex-wrap tw-gap-4 tw-pt-4"} -->
<div class="wp-block-buttons tw-flex tw-flex-wrap tw-gap-4 tw-pt-4">
<!-- wp:button {"backgroundColor":"background","textColor":"main-1","className":"medu-btn-hover-up is-style-fill","style":{"border":{"radius":"6px","width":"1px"},"elements":{"link":{"color":{"text":"var:preset|color|main-1"}}}},"borderColor":"background"} -->
<div class="wp-block-button medu-btn-hover-up is-style-fill"><a class="wp-block-button__link has-main-1-color has-background-background-color has-text-color has-background has-link-color has-border-color has-background-border-color wp-element-button" href="#" style="border-width:1px;border-radius:6px"><?php esc_html_e('Browse Courses', 'mine-educn'); ?></a></div>
<!-- /wp:button -->

<!-- wp:button {"textColor":"background","className":"medu-btn-hover-trans is-style-outline","style":{"border":{"radius":"6px","width":"1px"},"elements":{"link":{"color":{"text":"var:preset|color|background"}}}},"borderColor":"background"} -->
<div class="wp-block-button medu-btn-hover-trans is-style-outline"><a class="wp-block-button__link has-background-color has-text-color has-link-color has-border-color has-background-border-color wp-element-button" href="#" style="border-width:1px;border-radius:6px"><?php esc_html_e('Popular Recommendations', 'mine-educn'); ?></a></div>
<!-- /wp:button -->
</div>
<!-- /wp:buttons -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"50%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:50%">
<!-- wp:group {"style":{"dimensions":{"minHeight":""}},"layout":{"type":"default"}} -->
<div class="wp-block-group">
<!-- wp:image {"id":60,"scale":"cover","sizeSlug":"full","linkDestination":"none","className":"img-right","style":{"color":{"duotone":"unset"}}} -->
<figure class="wp-block-image size-full img-right"><img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/homeschooling.jpg" alt="" class="wp-image-60" style="object-fit:cover"/></figure>
<!-- /wp:image -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:column -->
</div>
<!-- /wp:columns -->
</div></div>
<!-- /wp:cover -->

<!-- wp:cover {"isUserOverlayColor":true,"customGradient":"radial-gradient(rgb(202,248,128) 0%,rgb(113,206,126) 100%)","contentPosition":"center center","metadata":{"name":"<?php esc_html_e('Carousel Item', 'mine-educn'); ?>"},"align":"full","className":"medu-carousel-item tw-flex-1","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignfull medu-carousel-item tw-flex-1" style="padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--80);padding-left:var(--wp--preset--spacing--30)"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-100 has-background-dim has-background-gradient" style="background:radial-gradient(rgb(202,248,128) 0%,rgb(113,206,126) 100%)"></span><div class="wp-block-cover__inner-container">
<!-- wp:columns {"verticalAlignment":"center","metadata":{"name":"<?php esc_html_e('Carousel Item', 'mine-educn'); ?>"},"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|80"}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center">
<!-- wp:column {"verticalAlignment":"center","width":"50%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:50%">
<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"constrained","justifyContent":"center"}} -->
<div class="wp-block-group">
<!-- wp:heading {"level":1,"fontSize":"xx-large"} -->
<h1 class="wp-block-heading has-xx-large-font-size"><?php esc_html_e('Explore the Infinite Possibilities of Future Learning', 'mine-educn'); ?></h1>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|background"}}}},"textColor":"background"} -->
<p class="has-text-align-left has-background-color has-text-color has-link-color"><?php esc_html_e('Over 1,000 premium courses available for learning anytime, anywhere, helping you master essential skills for your future career', 'mine-educn'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"className":"tw-flex tw-flex-wrap tw-gap-4 tw-pt-4"} -->
<div class="wp-block-buttons tw-flex tw-flex-wrap tw-gap-4 tw-pt-4">
<!-- wp:button {"backgroundColor":"background","textColor":"vivid-green-cyan","className":"medu-btn-hover-up is-style-fill","style":{"border":{"radius":"6px","width":"1px"},"elements":{"link":{"color":{"text":"var:preset|color|vivid-green-cyan"}}}},"borderColor":"background"} -->
<div class="wp-block-button medu-btn-hover-up is-style-fill"><a class="wp-block-button__link has-vivid-green-cyan-color has-background-background-color has-text-color has-background has-link-color has-border-color has-background-border-color wp-element-button" href="#" style="border-width:1px;border-radius:6px"><?php esc_html_e('Browse Courses', 'mine-educn'); ?></a></div>
<!-- /wp:button -->

<!-- wp:button {"textColor":"background","className":"medu-btn-hover-trans is-style-outline","style":{"border":{"radius":"6px","width":"1px"},"elements":{"link":{"color":{"text":"var:preset|color|background"}}}},"borderColor":"background"} -->
<div class="wp-block-button medu-btn-hover-trans is-style-outline"><a class="wp-block-button__link has-background-color has-text-color has-link-color has-border-color has-background-border-color wp-element-button" href="#" style="border-width:1px;border-radius:6px"><?php esc_html_e('Popular Recommendations', 'mine-educn'); ?></a></div>
<!-- /wp:button -->
</div>
<!-- /wp:buttons -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"50%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:50%">
<!-- wp:group {"style":{"dimensions":{"minHeight":""}},"layout":{"type":"default"}} -->
<div class="wp-block-group">
<!-- wp:image {"id":60,"scale":"cover","sizeSlug":"full","linkDestination":"none","className":"img-left","style":{"color":{"duotone":"unset"}}} -->
<figure class="wp-block-image size-full img-left"><img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/homeschooling.jpg" alt="" class="wp-image-60" style="object-fit:cover"/></figure>
<!-- /wp:image -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:column -->
</div>
<!-- /wp:columns -->
</div></div>
<!-- /wp:cover -->
</div>
<!-- /wp:group -->
</div>
<!-- /wp:group -->

<!-- wp:buttons {"className":"medu-carousel-btns","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"x-small"} -->
<div class="wp-block-buttons has-custom-font-size medu-carousel-btns has-x-small-font-size" style="margin-top:0;margin-bottom:0">
<!-- wp:button {"className":"medu-carousel-prev","style":{"border":{"radius":"50%"},"spacing":{"padding":{"left":"var:preset|spacing|10","right":"var:preset|spacing|10","top":"var:preset|spacing|10","bottom":"var:preset|spacing|10"}},"color":{"background":"#ffffff4a"}},"fontSize":"x-small"} -->
<div class="wp-block-button medu-carousel-prev"><a class="wp-block-button__link has-background has-x-small-font-size has-custom-font-size wp-element-button" style="border-radius:50%;background-color:#ffffff4a;padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)"> </a></div>
<!-- /wp:button -->

<!-- wp:button {"className":"medu-carousel-next","style":{"border":{"radius":"50%"},"spacing":{"padding":{"left":"var:preset|spacing|10","right":"var:preset|spacing|10","top":"var:preset|spacing|10","bottom":"var:preset|spacing|10"}},"color":{"background":"#ffffff4a"}},"fontSize":"x-small"} -->
<div class="wp-block-button medu-carousel-next"><a class="wp-block-button__link has-background has-x-small-font-size has-custom-font-size wp-element-button" style="border-radius:50%;background-color:#ffffff4a;padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)"> </a></div>
<!-- /wp:button -->
</div>
<!-- /wp:buttons -->
</section>
<!-- /wp:group -->