<?php 

class Mine_Educn_Init {
    public function __construct() {
        $this->includes();

        add_action('init',                  [$this, 'init']);
        add_action('wp_enqueue_scripts',    [$this, 'enqueue_scripts']);
        add_action('after_setup_theme',     [$this, 'enqueue_editor_styles']);
        add_action('tgmpa_register',       [$this, 'register_required_plugins']);

        add_filter('body_class',            [$this, 'body_class']);
    }
    public function init() {
        // 注册区块样式分类
        if (function_exists('register_block_pattern_category')) {
            register_block_pattern_category(
                'mine-educn',
                array('label' => __('Mine EduCN', 'mine-educn'))
            );
        }
    }
    /**
    * 为body添加类
    */
    public function body_class($classes) {
        $classes[] = 'medu-body';
        return $classes;
    }
    /**
     * 添加前台脚本和样式
     */
    public function enqueue_scripts() {
        wp_enqueue_style('medu-global', MINE_EDUCN_URI . '/assets/css/global.css', [], null);
        wp_enqueue_script('jquery');
        wp_enqueue_script('medu-main', MINE_EDUCN_URI . '/assets/js/index.js', ['jquery'], null, true);
    }
    /**
     * 添加编辑器样式
     */
    public function enqueue_editor_styles() {
        add_editor_style('assets/css/global.css');
    }

    private function includes() {
        require MINE_EDUCN_DIR . '/inc/class-tgm-plugin-activation.php';
    }
    public function register_required_plugins() {
        $plugins = array(
            array(
                'name'     => __( 'Mine CloudVod', 'mine-educn' ),
                'slug'     => 'mine-cloudvod',
                'required' => false,
            ),
        );

        $config = array(
            'id'           => 'mine-educn',            // Unique ID for hashing notices for multiple instances of TGMPA.
            'default_path' => '',                      // Default absolute path to bundled plugins.
            'menu'         => 'tgmpa-install-plugins', // Menu slug.
            'has_notices'  => true,                    // Show admin notices or not.
            'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
            'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
            'is_automatic' => false,                   // Automatically activate plugins after installation or not.
            'message'      => '',                      // Message to output right before the plugins table.
        );

        tgmpa( $plugins, $config );
    }
}
new Mine_Educn_Init();