<?php

/**
 * Title: FAQ with CTA
 * Slug: millipede/faq-cta
 * Categories: millipede
 */
?>
<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"120px","bottom":"120px","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}}},"layout":{"type":"constrained","contentSize":"1180px"}} -->
<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:120px;padding-right:var(--wp--preset--spacing--40);padding-bottom:120px;padding-left:var(--wp--preset--spacing--40)"><!-- wp:group {"layout":{"type":"constrained","contentSize":"1080px"}} -->
    <div class="wp-block-group"><!-- wp:columns {"style":{"spacing":{"blockGap":{"left":"80px"}}}} -->
        <div class="wp-block-columns"><!-- wp:column {"width":"35%"} -->
            <div class="wp-block-column" style="flex-basis:35%"><!-- wp:heading {"textAlign":"left","level":1,"fontSize":"xx-large"} -->
                <h1 class="wp-block-heading has-text-align-left has-xx-large-font-size"><?php esc_html_e('FAQ', 'millipede') ?></h1>
                <!-- /wp:heading -->

                <!-- wp:paragraph -->
                <p><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.', 'millipede') ?></p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:column -->

            <!-- wp:column -->
            <div class="wp-block-column"><!-- wp:details {"style":{"border":{"width":"0px","style":"none"},"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}}},"textColor":"heading-color","fontSize":"medium"} -->
                <details class="wp-block-details has-heading-color-color has-text-color has-link-color has-medium-font-size" style="border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0">
                    <summary><?php esc_html_e('What is Full Site Editing in WordPress?', 'millipede') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","fontSize":"normal"} -->
                    <p class="has-normal-font-size"><?php esc_html_e('Full Site Editing in WordPress refers to a feature that allows users to create and edit their website\'s entire layout, including the header, footer, and other structural elements, using a visual editor.', 'millipede') ?></p>
                    <!-- /wp:paragraph -->
                </details>
                <!-- /wp:details -->

                <!-- wp:details {"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}}},"textColor":"heading-color","fontSize":"medium"} -->
                <details class="wp-block-details has-heading-color-color has-text-color has-link-color has-medium-font-size">
                    <summary><?php esc_html_e('What are the benefits of Full Site Editing in WordPress?', 'millipede') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","fontSize":"normal"} -->
                    <p class="has-normal-font-size"><?php esc_html_e('Full Site Editing in WordPress allows users to create and edit their website more efficiently and with more control. It enables users to create unique and custom designs without needing to have advanced coding skills.', 'millipede') ?></p>
                    <!-- /wp:paragraph -->
                </details>
                <!-- /wp:details -->

                <!-- wp:details {"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}}},"textColor":"heading-color","fontSize":"medium"} -->
                <details class="wp-block-details has-heading-color-color has-text-color has-link-color has-medium-font-size">
                    <summary><?php esc_html_e('How do I enable Full Site Editing in WordPress?', 'millipede') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","fontSize":"normal"} -->
                    <p class="has-normal-font-size"><?php esc_html_e('To enable Full Site Editing in WordPress, you need to ensure that you are using a compatible WordPress theme that supports Full Site Editing. You will also need to install the latest version of WordPress and enable the Gutenberg editor.', 'millipede') ?></p>
                    <!-- /wp:paragraph -->
                </details>
                <!-- /wp:details -->

                <!-- wp:details {"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}}},"textColor":"heading-color","fontSize":"medium"} -->
                <details class="wp-block-details has-heading-color-color has-text-color has-link-color has-medium-font-size">
                    <summary><?php esc_html_e('What are some popular WordPress themes that support Full Site Editing?', 'millipede') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","fontSize":"normal"} -->
                    <p class="has-normal-font-size"><?php esc_html_e('Some popular WordPress themes that support Full Site Editing include the Millipede Theme, AvatarNews Theme, and the Mediator Theme. These themes have built-in support for Full Site Editing, allowing users to create custom designs without needing to know how to code.', 'millipede') ?></p>
                    <!-- /wp:paragraph -->
                </details>
                <!-- /wp:details -->

                <!-- wp:details {"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}}},"textColor":"heading-color","fontSize":"medium"} -->
                <details class="wp-block-details has-heading-color-color has-text-color has-link-color has-medium-font-size">
                    <summary><?php esc_html_e('How do I enable Full Site Editing in WordPress?', 'millipede') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","fontSize":"normal"} -->
                    <p class="has-normal-font-size"><?php esc_html_e('To enable Full Site Editing in WordPress, you need to ensure that you are using a compatible WordPress theme that supports Full Site Editing. You will also need to install the latest version of WordPress and enable the Gutenberg editor.', 'millipede') ?></p>
                    <!-- /wp:paragraph -->
                </details>
                <!-- /wp:details -->

                <!-- wp:details {"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}}},"textColor":"heading-color","fontSize":"medium"} -->
                <details class="wp-block-details has-heading-color-color has-text-color has-link-color has-medium-font-size">
                    <summary><?php esc_html_e('How do I enable Full Site Editing in WordPress?', 'millipede') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","fontSize":"normal"} -->
                    <p class="has-normal-font-size"><?php esc_html_e('To enable Full Site Editing in WordPress, you need to ensure that you are using a compatible WordPress theme that supports Full Site Editing. You will also need to install the latest version of WordPress and enable the Gutenberg editor.', 'millipede') ?></p>
                    <!-- /wp:paragraph -->
                </details>
                <!-- /wp:details -->

                <!-- wp:details {"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}}},"textColor":"heading-color","fontSize":"medium"} -->
                <details class="wp-block-details has-heading-color-color has-text-color has-link-color has-medium-font-size">
                    <summary><?php esc_html_e('How do I enable Full Site Editing in WordPress?', 'millipede') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","fontSize":"normal"} -->
                    <p class="has-normal-font-size"><?php esc_html_e('To enable Full Site Editing in WordPress, you need to ensure that you are using a compatible WordPress theme that supports Full Site Editing. You will also need to install the latest version of WordPress and enable the Gutenberg editor.', 'millipede') ?></p>
                    <!-- /wp:paragraph -->
                </details>
                <!-- /wp:details -->
            </div>
            <!-- /wp:column -->
        </div>
        <!-- /wp:columns -->
    </div>
    <!-- /wp:group -->

    <!-- wp:group {"style":{"spacing":{"padding":{"top":"44px","bottom":"68px","left":"var:preset|spacing|70","right":"var:preset|spacing|70"},"margin":{"top":"120px"},"blockGap":"var:preset|spacing|40"},"border":{"radius":"12px"},"color":{"gradient":"linear-gradient(135deg,rgb(67,98,234) 0%,rgb(163,138,220) 100%)"}},"layout":{"type":"constrained","contentSize":"840px"}} -->
    <div class="wp-block-group has-background" style="border-radius:12px;background:linear-gradient(135deg,rgb(67,98,234) 0%,rgb(163,138,220) 100%);margin-top:120px;padding-top:44px;padding-right:var(--wp--preset--spacing--70);padding-bottom:68px;padding-left:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","level":1,"style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}},"typography":{"lineHeight":"1.4"}},"textColor":"light-color","fontSize":"xx-large"} -->
        <h1 class="wp-block-heading has-text-align-center has-light-color-color has-text-color has-link-color has-xx-large-font-size" style="line-height:1.4"><?php esc_html_e('Ready to get started?', 'millipede') ?></h1>
        <!-- /wp:heading -->

        <!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}}},"textColor":"light-color","fontSize":"medium"} -->
        <p class="has-text-align-center has-light-color-color has-text-color has-link-color has-medium-font-size"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.', 'millipede') ?></p>
        <!-- /wp:paragraph -->

        <!-- wp:buttons {"style":{"spacing":{"margin":{"top":"40px"}}},"layout":{"type":"flex","justifyContent":"center"}} -->
        <div class="wp-block-buttons" style="margin-top:40px"><!-- wp:button {"backgroundColor":"background","textColor":"heading-color","className":"is-style-button-hover-secondary-bgcolor","style":{"spacing":{"padding":{"left":"var:preset|spacing|60","right":"var:preset|spacing|60","top":"24px","bottom":"24px"}},"border":{"radius":"7px"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}}},"fontSize":"medium"} -->
            <div class="wp-block-button has-custom-font-size is-style-button-hover-secondary-bgcolor has-medium-font-size"><a class="wp-block-button__link has-heading-color-color has-background-background-color has-text-color has-background has-link-color wp-element-button" style="border-radius:7px;padding-top:24px;padding-right:var(--wp--preset--spacing--60);padding-bottom:24px;padding-left:var(--wp--preset--spacing--60)"><?php esc_html_e('Schedule an Appointment', 'millipede') ?></a></div>
            <!-- /wp:button -->
        </div>
        <!-- /wp:buttons -->
    </div>
    <!-- /wp:group -->
</div>
<!-- /wp:group -->