"use strict";
/*!
@package      A11y Menu
@description  A keyboard accessible navigational menu script.
@version      1.3.0
@author       WebMan Design, Oliver Juhas, https://www.webmandesign.eu
@copyright    2019 WebMan Design, Oliver Juhas
@license      GPL-3.0-or-later, https://www.gnu.org/licenses/gpl-3.0-standalone.html
@link         https://github.com/webmandesign/a11y-menu

@global  window, document, a11yMenuConfig
*/!function(t){var e={init:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this;e.setOptions(t),e.polyfill(),e.getMenus().length&&e.getOption("expanded_class")&&e.getMenus().forEach((function(t){var n=t.querySelectorAll(e.getOption("child_menu_selector"));if(Object.keys(n).length){var o=e.getButton(e.getOption("button_attributes"));n.forEach((function(t){var n=t.parentNode;if(n.classList.add("a11y-menu--has-children"),null!=o){var a=n.getElementsByClassName(e.getOption("button_attributes","class"))[0];void 0===a&&(a=o.cloneNode(!0),n.insertBefore(a,t)),e.changeButtonAttributes(n),a.addEventListener("mousedown",(function(t){return e.onClickButton(t)})),a.addEventListener("keyup",(function(t){return e.onClickButton(t)}))}if(e.isMode("touch")){var i=n.querySelector("a[href]");null!=i&&i.addEventListener("touchstart",(function(t){return e.onTouchLink(t)}),!0)}})),e.isMode("tab")&&(t.addEventListener("focusin",(function(t){return e.onFocus(t)}),!0),t.addEventListener("focusout",(function(t){return e.onFocus(t)}),!0)),e.isMode("esc")&&document.addEventListener("keyup",(function(t){return e.onKeyESC(t)}))}}))},onFocus:function(t){var e=this,n=e.getParents(t);"focusin"===t.type?n.map((function(t){return t.classList.add(e.getOption("expanded_class"))})):n.map((function(t){return t.classList.remove(e.getOption("expanded_class"))})),e.isMode("button")&&(e.changeButtonAttributes(t),n.map((function(t){return e.changeButtonAttributes(t)})))},onClickButton:function(t){if("keyup"===t.type&&-1===[13,32].indexOf(t.keyCode))return!1;var e=this,n=e.getOption("expanded_class"),o=t.target.parentNode,a=o.classList.contains(n);e.getSiblings(o).map((function(t){t.classList.remove(n),e.changeButtonAttributes(t)})),a?o.classList.remove(n):o.classList.add(n),e.changeButtonAttributes(t),e.getParents(o).map((function(t){return e.changeButtonAttributes(t)})),t.preventDefault()},onTouchLink:function(t){var e=this,n=t.target,o=n.parentNode,a=e.getOption("expanded_class");if(o.classList.contains(a))n!==document.activeElement&&(t.preventDefault(),o.classList.remove(a),e.isMode("button")&&e.changeButtonAttributes(t));else{t.preventDefault(),n.focus();var i=e.getSiblings(o),s=e.getParents(t);i.map((function(t){return t.classList.remove(a)})),s.map((function(t){return t.classList.add(a)})),e.isMode("button")&&(e.changeButtonAttributes(t),s.map((function(t){return e.changeButtonAttributes(t)})))}},onKeyESC:function(t){if(27===t.keyCode){var e=this,n=e.getOption("expanded_class");e.getMenus().forEach((function(t){t.querySelectorAll("."+n).forEach((function(t){t.classList.remove(n),e.isMode("button")&&e.changeButtonAttributes(t)}))}))}},getMenus:function(){var t=this,e=t.getOption("menu_selector");return!t.menus.length&&e&&document.querySelectorAll(e).forEach((function(e){return t.menus.push(e)})),t.menus},getSiblings:function(t){for(var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:".a11y-menu--has-children",n=[],o=t.parentNode.firstChild;o;o=o.nextElementSibling)1===o.nodeType&&o.matches(e)&&t!==o&&n.push(o);return n},getParents:function(t){for(var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"a11y-menu--has-children",n=this,o=n.getMenus(),a=[],i=1===t.nodeType?t:t.target;-1===o.indexOf(i);)a.push(i),i=i.parentNode;return e&&(a=a.filter((function(t){return t.matches(e)}))),a},getButton:function(t){t=t||{};var e=Object.keys(t);if(!e.length||!this.isMode("button"))return null;var n=document.createElement("button"),o=["class","tabindex","title"];return n.setAttribute("aria-expanded","false"),e.forEach((function(e){-1===o.indexOf(e)&&0!==e.indexOf("aria-")&&0!==e.indexOf("data-")||n.setAttribute(e.toLowerCase(),t[e])})),null!=t["aria-label"]&&null!=t["aria-label"].expand&&n.setAttribute("aria-label",t["aria-label"].expand),n},changeButtonAttributes:function(t){var e,n=1===t.nodeType?t:t.target.parentNode,o="";if(null!=n&&(e=n.querySelector("[aria-expanded]")),null!=e&&1===e.nodeType){var a=n.querySelector("a[data-submenu-label]");null!=a&&(o=a.dataset.submenuLabel);var i=n.classList.contains(this.getOption("expanded_class")),s=this.getOption("button_attributes","aria-label");"string"!=typeof s&&null!=s&&(i&&null!=s.collapse?e.setAttribute("aria-label",s.collapse.replace("%s",o)):i||null==s.expand||e.setAttribute("aria-label",s.expand.replace("%s",o))),e.setAttribute("aria-expanded",i.toString())}},setOptions:function(t){var e={button_attributes:{class:"button-toggle-sub-menu","aria-label":{collapse:"Collapse child menu",expand:"Expand child menu"}},child_menu_selector:".sub-menu",expanded_class:"has-expanded-sub-menu",menu_selector:"nav .menu",mode:["tab","esc","button","touch"]};for(var n in t)e.hasOwnProperty(n)&&(e[n]="expanded_class"===n?t[n].replace(/[^a-zA-Z0-9\-_]/g,""):t[n]);this.options=e,this.menus=[]},getOption:function(){var t=this.options,e=arguments,n=e.length;if(1===n)t=null!=t[e[0]]&&t[e[0]];else for(var o=0;o<n&&!1!==t;o++)t=null!=t[e[o]]&&t[e[o]];return t},isMode:function(t){return-1!==this.getOption("mode").indexOf(t)},polyfill:function(){window.NodeList&&!NodeList.prototype.forEach&&(NodeList.prototype.forEach=Array.prototype.forEach),Element.prototype.matches||(Element.prototype.matches=Element.prototype.msMatchesSelector||Element.prototype.webkitMatchesSelector)}};"loading"===document.readyState?document.addEventListener("DOMContentLoaded",(function(){return e.init(t)})):e.init(t)}(window.a11yMenuConfig||{});
