<?php 
/**
 * The template for displaying index page
 *
 * @version    0.1.90
 * @package    mhix
 * @author     Zidithemes
 * @copyright  Copyright (C) 2021 zidithemes.com All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * 
 */
?>

<?php get_header(); ?>

<?php

$is_elementor_theme_exist = function_exists( 'elementor_theme_do_location' );


if ( ! $is_elementor_theme_exist || ! elementor_theme_do_location( 'index' ) ) {

?>

<div id="content" class="page-content">

	
	<div class="flowid mhix-index ">

		<div class="mhix-show mhix-show-mob-no dsply-fl fl-wrap">
		<div class="mg-auto wid-90 mobwid-90 dsply-fl fl-wrap">
			<div class="left-side wid-50 mobwid-100">
			<?php $mhix_index_blog_posts = new WP_Query( array( 'posts_per_page' => 1, 'paged' => $paged ) );

                        if ( $mhix_index_blog_posts->have_posts() ) : while ( $mhix_index_blog_posts->have_posts() ) : $mhix_index_blog_posts->the_post(); ?>

                        <div class="wid-100 mobwid-100 mhix-show-items relative">
	                        	<?php if ( has_post_thumbnail()) : ?>
				                <a href="<?php esc_url( the_permalink() ); ?>"  >
				                    <?php the_post_thumbnail(); ?>
				                </a>
				                <?php else: ?>
				                	<a href="<?php esc_url( the_permalink() ); ?>"  >
					                    <div class="user-no-img-items">
					                        <div class="user-no-img-items-inner text-center">
					                            <div class=""><?php esc_html_e( 'No Image', 'mhix' ); ?></div>
					                        </div>
					                    </div>
				                	</a>
				                <?php endif; ?>
					            <div class="mhix-show-items-content text-center">
					                <div class="date"><?php the_time(get_option('date_format')); ?></div>
					                <h5><a href="<?php esc_url( the_permalink() ); ?>"  >
					                        <?php the_title(); ?>
					                    </a>
					                </h5>
					                <p><a class="excerpt" href="<?php esc_url( the_permalink() ); ?>"><?php the_excerpt(__('Read more &raquo;', 'mhix')); ?></a></p>
					            </div>
					        
                        </div>

				<?php endwhile; else : ?>
				<h2><?php esc_html__('No posts Found!', 'mhix'); ?></h2>
				<?php endif; ?>	

			</div>
			<div class="right-side wid-50 dsply-fl fl-wrap jc-sp-btw mobwid-100">
				<?php $mhix_index_right_side_blog_posts = new WP_Query( array( 'posts_per_page' => 5, 'paged' => $paged ) );

                        if ( $mhix_index_right_side_blog_posts->have_posts() ) : while ( $mhix_index_right_side_blog_posts->have_posts() ) : $mhix_index_right_side_blog_posts->the_post(); ?>

                        <div class="wid-49 dsply-fl mobwid-100 mhix-show-items relative">
                        		<div class="wid-100 relative mhix-show-items-link">
		                        	<?php if ( has_post_thumbnail()) : ?>
					                <a href="<?php esc_url( the_permalink() ); ?>"  >
					                    <?php the_post_thumbnail(); ?>
					                </a>
					                <?php else: ?>
					                	<a href="<?php esc_url( the_permalink() ); ?>"  >
						                    <div class="user-no-img-items">
						                        <div class="user-no-img-items-inner text-center">
						                            <div class=""><?php esc_html_e( 'No Image', 'mhix' ); ?></div>
						                        </div>
						                    </div>
					                	</a>
					                <?php endif; ?>
				            	</div>
					            <div class="wid-100 jc-center ai-center dsply-fl mhix-show-items-content text-center">
					            	<div class="mhix-show-items-content-inner">
						                <div class="date"><?php the_time(get_option('date_format')); ?></div>
						                <h5><a href="<?php esc_url( the_permalink() ); ?>"  >
						                        <?php the_title(); ?>
						                    </a>
						                </h5>
						                <p class="para"><a class="excerpt" href="<?php esc_url( the_permalink() ); ?>"><?php the_excerpt(__('Read more &raquo;', 'mhix')); ?></a></p>
					            	</div>
					            </div>
					        
                        </div>

				<?php endwhile; else : ?>
				<h2><?php esc_html__('No posts Found!', 'mhix'); ?></h2>
				<?php endif; ?>	
			</div>
		</div>
		</div>


	    <div class="mg-auto wid-90 mobwid-90">
	        
	        <div class="inner dsply-fl fl-wrap">
	            
	            <div class="wid-70 mobwid-100 blog-2-col-inner">
	            	
	                <div class="mg-tp dsply-fl fl-wrap">
	                <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>	

	                	<?php get_template_part('content', get_post_format());  ?>
	                	 
	                	
	                    <?php endwhile; else : ?>
						<h2><?php esc_html__('No posts Found!', 'mhix'); ?></h2>
	                    <?php endif; ?>

	                </div>
	                <ul class="pagination flowid">
					   <?php the_posts_pagination(); ?>
					</ul>
	            </div>
	            <?php get_sidebar(); ?>

	        </div>
	    </div>
	</div>

</div>

<?php } ?>



<?php get_footer(); ?>