<?php


function mhix_theme_info_menu() {

	add_theme_page( 
		esc_html__('Welcome To Mhix WordPress Theme', 'mhix'), 
		esc_html__('Mhix Theme Info', 'mhix'), 
		'manage_options', 
		'mhix_theme_info_options', 
		'mhix_theme_info_display' 
	);

}


add_action( 'admin_menu', 'mhix_theme_info_menu' );



function mhix_theme_info_display() {
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( esc_html_e( 'You do not have sufficient permissions to access this page.', 'mhix' ) );
	}
	
	?>
	<div class="wrap mhix-adm">
		<h1 class="header-welcome"><?php esc_html_e('Welcome to Mhix - 0.1.90', 'mhix'); ?></h1>
		<div class="mhix-adm-dsply-fl mhix-adm-fl-wrap mhix-adm-jc-sp-btw">

			<div class="mhix-adm-wid-49 theme-para theme-doc mhix-adm-mobwid-100">
				<h4><?php esc_html_e('Theme Documentation','mhix'); ?></h4>
				<p><?php esc_html_e('Documentation for this theme includes all theme information that is needed to get your site up and running', 'mhix'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://zidithemes.com/mhix/'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Theme Documentation', 'mhix'); ?>
					</a>
				</p>
			</div>

			<div class="mhix-adm-wid-49 theme-para theme-opt mhix-adm-mobwid-100">
				<h4><?php esc_html_e('Mhix Pro','mhix'); ?></h4>
				<p class="">
					<?php esc_html_e('Mhix Pro includes portfolio page templates, additional features and more options to customize your website.',  'mhix'); ?>
				</p>
				<p>
					<a href="<?php echo esc_url('https://zidithemes.com/mhix-pro/'); ?>" class="button button-primary" target="_blank">
						<?php esc_html_e('Upgrade to Mhix Pro', 'mhix'); ?>
					</a>
				</p>
			</div>

			<div class="mhix-adm-wid-49 theme-para theme-opt mhix-adm-mobwid-100">
				<h4><?php esc_html_e('Theme Options','mhix'); ?></h4>
				<p class="">
					<?php esc_html_e('mhix Theme supports Theme Customizer. Click "Go To Customizer" to open the Customizer now.',  'mhix'); ?>
				</p>
				<p>
					<a href="<?php echo esc_url( admin_url('customize.php') ); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Go To Customizer', 'mhix'); ?>
					</a>
				</p>
			</div>

			<div class="mhix-adm-wid-49 theme-para theme-review mhix-adm-mobwid-100">
				<h4><?php esc_html_e('Leave us a review','mhix'); ?></h4>
				<p><?php esc_html_e('We would love to hear your feedback.', 'mhix'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://wordpress.org/support/theme/mhix/reviews/#new-post'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Submit a review', 'mhix'); ?>
					</a>
				</p>
			</div>


			<div class="mhix-adm-wid-49 theme-para theme-support mhix-adm-mobwid-100">
				<h4><?php esc_html_e('Support','mhix'); ?></h4>
				<p><?php esc_html_e('Reach out in the theme support forums on WordPress.org.', 'mhix'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://wordpress.org/support/theme/mhix/'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Support Forum', 'mhix'); ?>
					</a>
				</p>
			</div>


			<div class="theme-upgrade mhix-adm-wid-100">
				<table class="mhix-adm-wid-100">
					<thead class="theme-table-head">
						<tr>
							<th class="feature"><h3><?php esc_html_e('Features', 'mhix'); ?></h3></th>
							<th class="mhix-adm-wid-33"><h3><?php esc_html_e('Mhix', 'mhix'); ?></h3></th>
							<th class="mhix-adm-wid-33"><h3><?php esc_html_e('Mhix Pro', 'mhix'); ?></h3></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td class="feature-items-title">
								<h3><?php esc_html_e('Theme Price', 'mhix'); ?></h3>
							</td>
							<td class="free-btn"><?php esc_html_e('Free', 'mhix'); ?></td>
							<td>
								<a class="pro-link-btn" href="<?php echo esc_url('https://zidithemes.com/mhix-pro/'); ?>" target="_blank">
									<?php esc_html_e('View Pricing', 'mhix'); ?>
								</a>
							</td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Responsive Design', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Portfolio Page Template', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Testimonials Page Template', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Team Page Template', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Gallery Page Template', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Pricing Page Template', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('One Column Post Template', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('3 News Grid Image Styles', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Full Width Template', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Footer Credits Options', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Color Options', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Gutenberg Compatible', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Elementor Compatible', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Major Browser Compatible', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Woocommerce Compatible', 'mhix'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class=""></td>
							<td class=""></td>
							<td class="go-pro">
								<span class="">
									<a class="link" href="<?php echo esc_url('https://zidithemes.com/mhix-pro/'); ?>" target="_blank">
										<?php esc_html_e('View Pro', 'mhix'); ?>
									</a>
								</span>
							</td>
						</tr>
					</tbody>
				</table>
			</div>

		</div>
	</div>
	<?php
}
?>
