<?php

function mhix_customizer_settings( $wp_customize ){


	//ADD PANEL
	$wp_customize->add_panel('mhix_site_layout_option_panel',
		array(
			'title'      => esc_html__('Mhix Theme - Customize Layout', 'mhix'),
			'priority'   => 2,
			'capability' => 'edit_theme_options',
		)
	);

	//BEGIN NAVIGATION BACKGROUND COLOR SECTION
	$wp_customize->add_section('mhix_navbar_section', array(
		'title' => __('Mhix Theme - Navbar BG Color', 'mhix'),
		'priority' => 10,
		'panel' => 'mhix_site_layout_option_panel',
	));

	
	//NAVBAR SECTION BACKGROUND COLOR
	$wp_customize->add_setting('mhix_navbar_section_bg_color_settings', array(
	    'default' => __('#324680', 'mhix'),
	    'sanitize_callback'  => 'esc_attr',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'mhix_navbar_section_bg_color_control', array(
	    'label'    => __('Navbar Background Color', 'mhix'),
	    'section'  => 'mhix_navbar_section',
	    'settings' => 'mhix_navbar_section_bg_color_settings',
	)));


	//BEGIN MHIX SHOW GRID DATE BACKGROUND COLOR SECTION
	$wp_customize->add_section('mhix_showgrid_date_section', array(
		'title' => __('Mhix Theme - Mhix ShowGrid Date BG Color', 'mhix'),
		'priority' => 11,
		'panel' => 'mhix_site_layout_option_panel',
	));

	
	//MHIX SHOW GRID DATE SECTION BACKGROUND COLOR
	$wp_customize->add_setting('mhix_showgrid_date_bg_color_settings', array(
	    'default' => __('#324680', 'mhix'),
	    'sanitize_callback'  => 'esc_attr',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'mhix_showgrid_date_bg_color_control', array(
	    'label'    => __('Show Grid Date Background Color', 'mhix'),
	    'section'  => 'mhix_showgrid_date_section',
	    'settings' => 'mhix_showgrid_date_bg_color_settings',
	)));


	//BEGIN SIDEBAR BACKGROUND COLOR SECTION
	$wp_customize->add_section('mhix_sidebar_section', array(
		'title' => __('Mhix Theme - Sidebar Header BG Color', 'mhix'),
		'priority' => 11,
		'panel' => 'mhix_site_layout_option_panel',
	));

	
	//SIDEBAR SECTION BACKGROUND COLOR
	$wp_customize->add_setting('mhix_sidebar_header_bg_color_settings', array(
	    'default' => __('#324680', 'mhix'),
	    'sanitize_callback'  => 'esc_attr',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'mhix_sidebar_header_bg_color_control', array(
	    'label'    => __('Sidebar Header Background Color', 'mhix'),
	    'section'  => 'mhix_sidebar_section',
	    'settings' => 'mhix_sidebar_header_bg_color_settings',
	)));



	//BEGIN MHIX PAGINATION BACKGROUND COLOR SECTION
	$wp_customize->add_section('mhix_pagination_section', array(
		'title' => __('Mhix Theme - Pagination BG Color', 'mhix'),
		'priority' => 11,
		'panel' => 'mhix_site_layout_option_panel',
	));

	
	//MHIX PAGINATION SECTION BACKGROUND COLOR
	$wp_customize->add_setting('mhix_pagination_bg_color_settings', array(
	    'default' => __('#324680', 'mhix'),
	    'sanitize_callback'  => 'esc_attr',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'mhix_pagination_bg_color_control', array(
	    'label'    => __('Page Numbers Background Color', 'mhix'),
	    'section'  => 'mhix_pagination_section',
	    'settings' => 'mhix_pagination_bg_color_settings',
	)));


	//BEGIN MHIX SEARCH BUTTON SIDEBAR BACKGROUND COLOR SECTION
	$wp_customize->add_section('mhix_search_btn_sidebar_section', array(
		'title' => __('Mhix Theme - Search Button BG Color', 'mhix'),
		'priority' => 11,
		'panel' => 'mhix_site_layout_option_panel',
	));

	
	//MHIX SEARCH BUTTON SIDEBAR SECTION BACKGROUND COLOR
	$wp_customize->add_setting('mhix_search_btn_sidebar_bg_color_settings', array(
	    'default' => __('#324680', 'mhix'),
	    'sanitize_callback'  => 'esc_attr',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'mhix_search_btn_sidebar_bg_color_control', array(
	    'label'    => __('Search Button Sidebar Background Color', 'mhix'),
	    'section'  => 'mhix_search_btn_sidebar_section',
	    'settings' => 'mhix_search_btn_sidebar_bg_color_settings',
	)));



	//BEGIN FOOTER BACKGROUND COLOR SECTION
	$wp_customize->add_section('mhix_footer_section', array(
		'title' => __('Mhix Theme - Footer BG Color', 'mhix'),
		'priority' => 11,
		'panel' => 'mhix_site_layout_option_panel',
	));

	
	//FOOTER SECTION BACKGROUND COLOR
	$wp_customize->add_setting('mhix_footer_bg_color_settings', array(
	    'default' => __('#324680', 'mhix'),
	    'sanitize_callback'  => 'esc_attr',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'mhix_footer_bg_color_control', array(
	    'label'    => __('footer Header Background Color', 'mhix'),
	    'section'  => 'mhix_footer_section',
	    'settings' => 'mhix_footer_bg_color_settings',
	)));



    $wp_customize->get_setting('mhix_navbar_section_bg_color_settings')->transport        		= 	'postMessage';
    $wp_customize->get_setting('mhix_showgrid_date_bg_color_settings')->transport 				= 	'postMessage';
    $wp_customize->get_setting('mhix_sidebar_header_bg_color_settings')->transport 				= 	'postMessage';
    $wp_customize->get_setting('mhix_search_btn_sidebar_bg_color_settings')->transport 				= 	'postMessage';
    $wp_customize->get_setting('mhix_pagination_bg_color_settings')->transport 				= 	'postMessage';
    $wp_customize->get_setting('mhix_footer_bg_color_settings')->transport 				= 	'postMessage';


}


//CSS
function mhix_custom_css(){
	?>

<style type="text/css">


.nav-outer {
	background: <?php echo esc_html(get_theme_mod('mhix_navbar_section_bg_color_settings')); ?>;
}

.mhix-show .left-side .mhix-show-items .mhix-show-items-content .date {
	background: <?php echo esc_html(get_theme_mod('mhix_showgrid_date_bg_color_settings')); ?>; 
}

.sidebar .sidebar-inner .sidebar-items h2 {
	background: <?php echo esc_html(get_theme_mod('mhix_sidebar_header_bg_color_settings')); ?>;
}

.sidebar .sidebar-inner .sidebar-items .searchform div #searchsubmit {
	background: <?php echo esc_html(get_theme_mod('mhix_search_btn_sidebar_bg_color_settings')); ?>;
}

.page-numbers {
	background: <?php echo esc_html(get_theme_mod('mhix_pagination_bg_color_settings')); ?>;	
}

.footer-4-col {
	background: <?php echo esc_html(get_theme_mod('mhix_footer_bg_color_settings')); ?>; 
}

</style>


	<?php

}


function mhix_theme_customizer_live_preview()
{
	wp_enqueue_script( 
		  'mhix-theme-portfolio-page-customizer',			
		  get_template_directory_uri().'/js/mhix-customizer.js',
		  array( 'jquery','customize-preview' ),	
		  '',						
		  true						
	);
}




add_action('wp_head', 'mhix_custom_css');
add_action('customize_register', 'mhix_customizer_settings');
add_action( 'customize_preview_init', 'mhix_theme_customizer_live_preview' );


?>