<?php 
/**
 * The template for functions 
 *
 * @version    0.1.90
 * @package    mhix
 * @author     Zidithemes
 * @copyright  Copyright (C) 2021 zidithemes.com All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * 
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }


require get_template_directory() . "/inc/mhix-customizer.php";
require get_template_directory() . "/inc/mhix-options.php";

function mhix_setup(){
		
	// ADD THEME SUPPORT
	add_theme_support( 'title-tag' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( "custom-header" );
	add_theme_support( "custom-background" );
	add_theme_support( "post-thumbnails" );
	add_theme_support( 'custom-logo' );
	add_theme_support('woocommerce');

	// ADD EDITOR STYLE
	

	register_nav_menus(
	    array(
	      'primary-menu' => __( 'Primary Menu', 'mhix' ),
	    )
	  );


	// SET CONTENT WIDTH
	if ( ! isset( $content_width ) ) $content_width = 600;

}

add_action('after_setup_theme', 'mhix_setup');


function mhix_load_styles_scripts(){
	// NOTE:   SOME OF THESE SCRIPTS ARE HOSTED ON A CDN AND ARE NOT STORED LOCALLY... SO THIS THEME MAY NOT RENDER PROPERLY IF YOU ARE NOT CONNECTED TO THE INTERNET
	
		wp_enqueue_style( 'mhix-style', get_template_directory_uri() . '/style.css');
		
		wp_enqueue_style( 'mhix-google-notoSans-font', 'https://fonts.googleapis.com/css?family=Noto+Sans');

		wp_enqueue_script('mhix-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js' );

		if ( is_singular() && get_option( 'thread_comments' ) ) wp_enqueue_script( 'comment-reply' );
	
}

add_action('wp_enqueue_scripts', 'mhix_load_styles_scripts');



function mhix_pingback_wrap() {

		if ( is_singular() && pings_open() ) {
			echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
		}

}
add_action( 'wp_head', 'mhix_pingback_wrap' );


if (!function_exists('mhix_admin_style')) {
	function mhix_admin_style($hook) {
		
		if ('appearance_page_mhix_theme_info_options' === $hook) {
			wp_enqueue_style('mhix-admin-script-style', get_template_directory_uri() . '/css/mhix-admin.css');
		}
	}
}
add_action('admin_enqueue_scripts', 'mhix_admin_style');


// Creating the sidebar
function mhix_menu_init() {


register_sidebar(
		array(
                'name' 			=> esc_html__('Sidebar Widgets', 'mhix'),
                'id'    		=> 'sidebar_id',
                'class'       	=> '',
				'description' 	=> esc_html__('Add sidebar widgets here', 'mhix'),
				'before_widget' => '<div class="sidebar-items">',
				'after_widget' 	=> '</div>',
				'before_title' 	=> '<h2>',
				'after_title' 	=> '</h2>',
	));



	register_sidebar(array(
                'name' 			=> esc_html__('Left Footer', 'mhix'),
                'id'    		=> 'left_footer',
                'class' 		=> '',
				'description' 	=> esc_html__('Add widgets here', 'mhix'),
				'before_widget' => '<li>',
				'after_widget' 	=> '</li>',
				'before_title' 	=> '<h2>',
				'after_title' 	=> '</h2>',
	));
	
	register_sidebar(array(
                'name' 			=> esc_html__('Middle Footer', 'mhix'),
                'id'    		=> 'middle_footer',
                'class' 		=> '',
				'description' 	=> esc_html__('Add widgets here', 'mhix'),
				'before_widget' => '<li>',
				'after_widget' 	=> '</li>',
				'before_title'	=> '<h2>',
				'after_title' 	=> '</h2>',
	));
	
	register_sidebar(array(
                'name' 			=> esc_html__('Right Footer', 'mhix'),
                'id'    		=> 'right_footer',
                'class' 		=> '',
				'description' 	=> esc_html__('Add widgets here', 'mhix'),
				'before_widget' => '<li>',
				'after_widget' 	=> '</li>',
				'before_title' 	=> '<h2>',
				'after_title' 	=> '</h2>',
	));
	
	register_sidebar(array(
                'name' 			=> esc_html__('Fourth Footer', 'mhix'),
                'id'    		=> 'fourth_footer',
                'class' 		=> '',
				'description' 	=> esc_html__('Add widgets here', 'mhix'),
				'before_widget' => '<li>',
				'after_widget' 	=> '</li>',
				'before_title' 	=> '<h2>',
				'after_title' 	=> '</h2>',
	));

	register_sidebar(array(
                'name' 			=> esc_html__('Full Width Footer', 'mhix'),
                'id'    		=> 'full_width_footer',
                'class' 		=> '',
				'description' 	=> esc_html__('Add widgets here', 'mhix'),
				'before_widget' => '<li>',
				'after_widget' 	=> '</li>',
				'before_title' 	=> '<h2>',
				'after_title' 	=> '</h2>',
	));

}
add_action('widgets_init', 'mhix_menu_init');


// this increases or decreaes the length of the excerpt on the index page
function mhix_excerpt_length( $length ) {
	if ( is_admin() ) {
		return $length;
	}
	return 20;
}
add_filter( 'excerpt_length', 'mhix_excerpt_length', 999 );

function mhix_excerpt_more( $more ) {
    
    return ' <a class="read-more" href="'. esc_url( get_permalink( get_the_ID() ) ) . '">' . __('Read More', 'mhix') . '</a>';
}
add_filter( 'excerpt_more', 'mhix_excerpt_more' );



/**
 * Fix skip link focus in IE11.
 *
 * This does not enqueue the script because it is tiny and because it is only for IE11,
 * thus it does not warrant having an entire dedicated blocking script being loaded.
 *
 * @link https://git.io/vWdr2
 */
function mhix_skip_link_focus_fix() {
	// The following is minified via `terser --compress --mangle -- js/skip-link-focus-fix.js`.
	?>
	<script>
	/(trident|msie)/i.test(navigator.userAgent)&&document.getElementById&&window.addEventListener&&window.addEventListener("hashchange",function(){var t,e=location.hash.substring(1);/^[A-z0-9_-]+$/.test(e)&&(t=document.getElementById(e))&&(/^(?:a|select|input|button|textarea)$/i.test(t.tagName)||(t.tabIndex=-1),t.focus())},!1);
	</script>
	<?php
}
add_action( 'wp_print_footer_scripts', 'mhix_skip_link_focus_fix' );



?>