<?php
/**
 * devwp functions and definitions
 *
 * @package devwp
 * @since devwp 1.0
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 *
 * @since devwp 1.0
 */
if ( ! isset( $content_width ) )
	$content_width = 640; /* pixels */

if ( ! function_exists( 'devwp_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 *
 * @since devwp 1.0
 */
function devwp_setup() {

	/**
	 * Custom template tags for this theme.
	 */
	require( get_template_directory() . '/inc/template-tags.php' );

	/**
	 * Custom functions that act independently of the theme templates
	 */
	require( get_template_directory() . '/inc/extras.php' );

	/**
	 * Custom Theme Options
	 */
	/**
	 * There is a placeholder for theme options in the inc/theme-options folder.
	 * 
	 * Use it freely to add and extend theme options following the best coding practices. 
	 * 
	 */
	//require( get_template_directory() . '/inc/theme-options/theme-options.php' );

	/**
	 * Make theme available for translation
	 * Translations can be filed in the /languages/ directory
	 * If you're building a theme based on devwp, use a find and replace
	 * to change 'devwp' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'devwp', get_template_directory() . '/languages' );

	/**
	 * Add default posts and comments RSS feed links to head
	 */
	add_theme_support( 'automatic-feed-links' );

	/**
	 * Enable support for Post Thumbnails
	 */
	add_theme_support( 'post-thumbnails' );

	/**
	 * This theme uses wp_nav_menu() in one location.
	 */
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'devwp' ),
	) );

	/**
	 * Add support for the Aside Post Formats
	 */
	add_theme_support( 'post-formats', array( 'aside', ) );
}
endif; // devwp_setup
add_action( 'after_setup_theme', 'devwp_setup' );

/**
 * Register widgetized area and update sidebar with default widgets
 *
 * @since devwp 1.0
 */
function devwp_widgets_init() {
	register_sidebar( array(
		'name' => __( 'Sidebar', 'devwp' ),
		'id' => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h1 class="widget-title">',
		'after_title' => '</h1>',
	) );
}
add_action( 'widgets_init', 'devwp_widgets_init' );

/**
 * Enqueue scripts and styles
 */
function devwp_scripts() {
	wp_enqueue_style( 'style', get_stylesheet_uri() );

	wp_enqueue_script( 'small-menu', get_template_directory_uri() . '/js/small-menu.js', array( 'jquery' ), '20120206', true );
	
	wp_enqueue_style( 'devwp_fonts', 'http://fonts.googleapis.com/css?family=Dosis:200,400|Bad+Script|Waiting+for+the+Sunrise' );
	
	
	/**
	 * Should you use a specific layout, use the snippets in the /layouts folder.
	 * 
	 * There are different configurations available for providing a sidebars and content area layout positions.
	 */
// 	wp_enqueue_style( 'content-sidebar', get_template_directory_uri() . '/layouts/content-sidebar.css', array( 'style' ) );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	if ( is_singular() && wp_attachment_is_image() ) {
		wp_enqueue_script( 'keyboard-image-navigation', get_template_directory_uri() . '/js/keyboard-image-navigation.js', array( 'jquery' ), '20120202' );
	}
}
add_action( 'wp_enqueue_scripts', 'devwp_scripts' );

/**
 * Implement the Custom Header feature
 */
//require( get_template_directory() . '/inc/custom-header.php' );
