<?php
/**
 * Free vs. Pro section.
 *
 * @package Digimag Lite
 */

?>
<div id="pro" class="gt-tab-pane">
	<table class="form-table">
		<thead>
			<tr>
				<th></th>
				<th><?php esc_html_e( 'Lite', 'memory' ); ?></th>
				<th><?php esc_html_e( 'PRO', 'memory' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Responsive Design', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Works in any browsers on desktops, tablets and mobile devices and optimized for speed.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-yes"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Featured Content', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Show your most important posts in a slider on the front page. Install Jetpack to use this feature.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-yes"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Custom Homepage Layout', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Display your posts on homepage in grid or list layout.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-yes"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Grid Layout', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Select number of columns for the homepage.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Sidebar Layout', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Place a sidebar on either side of your blog theme, or have no sidebar at all..', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Post Layout', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Set post styles to match your preference: creative style, left thumbnail, right thumbnail, and more.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Single Post Layout', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Change how your single post display with many options.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( '1-Click Demo Import', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Save time setting up the theme and get exactly what you see in the demo.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Sticky Sidebar', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Glues your website \'s sidebar, making them permanently visible when scrolling up and down.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Sticky navigation', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Glues your website \'s header navigation, making them permanently visible when scrolling up and down.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Custom Google Fonts', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Integrated all Google Fonts with various options to customize for a beautiful typography.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Custom Colors', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Customize colors of any element on your website.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Instagram', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Showing your Instagram images in the footer or sidebar in an attractive format.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Social Media', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Display a module to show your social media stats.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Advertising', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Place the banner in between posts, at the top or bottom of a post or in unlimited positions within a sidebar.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Related Posts', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'Show related posts after posting to recommend previous posts from your blog to the visitors.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td>
					<h3><?php esc_html_e( 'Priority Support', 'memory' ); ?></h3>
					<p><?php esc_html_e( 'You will benefit of our full support for any issues you have with the theme.', 'memory' ); ?></p>
				</td>
				<td><span class="dashicons dashicons-no"></span></td>
				<td><span class="dashicons dashicons-yes"></span></td>
			</tr>
			<tr>
				<td></td>
				<td colspan="2">
					<a href="<?php echo esc_url( "https://gretathemes.com/wordpress-themes/{$this->slug}/{$this->utm}" ); ?>" target="_blank" class="button button-primary button-hero">
						<?php
						/* translators: pro theme name. */
						echo esc_html( sprintf( __( 'Get %s PRO now', 'memory' ), $this->theme->name ) );
						?>
					</a>
				</td>
			</tr>
		</tbody>
	</table>
</div>
