<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Mega_Store
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function mega_store_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	$show_catalog = get_theme_mod('mega_store_catalog_options', 'show');
	if($show_catalog === 'always'){
		$classes[] = 'show-catalog';
	}

	return $classes;
}
add_filter( 'body_class', 'mega_store_body_classes' );

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function mega_store_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'mega_store_pingback_header' );




