<?php
/**
	* Define Theme Version
 */
define( 'MEDISAFE_THEME_VERSION', '1.3' );	
	
function medisafe_css() {
	$parent_style = 'medazin-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'medisafe-style', get_stylesheet_uri(), array( $parent_style ));
	
	wp_enqueue_style('medisafe-color-default',get_stylesheet_directory_uri() .'/assets/css/color/default.css');
	wp_dequeue_style('medazin-default');
	
	wp_dequeue_style('medazin-media-query');
	wp_dequeue_style('medazin-fonts');
}
add_action( 'wp_enqueue_scripts', 'medisafe_css',999);
   	
if ( ! function_exists( 'medisafe_setup' ) ) :
function medisafe_setup()	{	
	
	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 */
	add_theme_support( 'title-tag' );
}
endif;
add_action( 'after_setup_theme', 'medisafe_setup' );

function medisafe_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'medazin_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => 'ffffff',
		'width'                  => 2000,
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'medazin_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'medisafe_custom_header_setup' );

/**
 * Import Options From Parent Theme
 *
 */
function medisafe_parent_theme_options() {
	$medazin_mods = get_option( 'theme_mods_axtria' );
	if ( ! empty( $medazin_mods ) ) {
		foreach ( $medazin_mods as $medazin_mod_k => $medazin_mod_v ) {
			set_theme_mod( $medazin_mod_k, $medazin_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'medisafe_parent_theme_options' );

/**
 * Called all the Customize file.
 */
require( get_stylesheet_directory() . '/inc/customize/medisafe-premium.php');