/**
 * MediHealth Admin Notice Scripts
 *
 * @package MediHealth WordPress theme
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        // Handle dismiss via WordPress default dismiss button or custom link
        $(document).on('click', '#medihealth-welcome-notice .notice-dismiss, .medihealth-dismiss-notice', function(e) {
            e.preventDefault();
            
            $.ajax({
                url: medihealthAdminNotice.ajaxurl,
                type: 'POST',
                data: {
                    action: 'medihealth_dismiss_notice',
                    nonce: medihealthAdminNotice.nonce
                },
                success: function(response) {
                    if (response.success) {
                        $('#medihealth-welcome-notice').fadeOut();
                    }
                }
            });
        });
    });
})(jQuery);
