<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'MediHealth_Customizer' ) ) :

	/**
	 * The MediHealth Customizer class
	 */
	class MediHealth_Customizer {

		/**
		 * Setup class.
		 */
		public function __construct() {
			add_action( 'customize_register', array( $this, 'custom_controls' ) );
			add_action( 'customize_register', array( $this, 'controls_helpers' ) );
			add_action( 'customize_register', array( $this, 'customizer_selector' ) );
			add_action( 'customize_register', array( $this, 'customizer_options' ) );
		}

		/**
		 * Add custom controls
		 */
		public function custom_controls( $wp_customize ) {

			// Path
			$dir = MEDIHEALTH_THEME_DIR . '/include/customizer/controls/';

			// Load customize control classes
			require_once( $dir . 'toggle/toggle-control.php' 							);
			require_once( $dir . 'range-slider/range-slider-control.php' 				);
			require_once( $dir . 'select/select-control.php' 							);
			
		}

		/**
		 * Add customizer helpers
		 */
		public function controls_helpers() {
			require_once( MEDIHEALTH_THEME_DIR .'/include/customizer/customizer-helpers.php' );
			require_once( MEDIHEALTH_THEME_DIR .'/include/customizer/callbacks.php' );
		}

		/**
		 * Input field settings code (title + description)
		 */
		function medihealth_repeater_sanitize($input){
			$input_decoded = json_decode($input,true);

			if(!empty($input_decoded)) {
				foreach ($input_decoded as $boxk => $box ){
					foreach ($box as $key => $value){
							$input_decoded[$boxk][$key] = wp_kses_post( force_balance_tags( $value ) );
					}
				}
				return json_encode($input_decoded);
			}
			return $input;
		}
		
		/**
		 * Add customizer Selector
		 */
		public function customizer_selector( $wp_customize ) {
			require_once( MEDIHEALTH_THEME_DIR .'/include/customizer/customizer-selector.php' );
		}
		
		/**
		 * Core modules
		 */
		public function customizer_options( $wp_customize ) {
			$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
			$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
			$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
			/**
			 * MediHealth Theme Options Panel
			 */
			$wp_customize->add_panel( 'medihealth_theme_options' , array(
				'title' 			=> esc_html__( 'MediHealth Options', 'medihealth' ),
				'priority' 			=> 200,
			) );
			
				/**
				 * Theme Setup Guide Section (always visible)
				 */
				$wp_customize->add_section( 'medihealth_setup_guide_section', array(
					'title'       => esc_html__( 'Theme Setup Guide', 'medihealth' ),
					'description' => sprintf(
						'<div class="medihealth-setup-guide">
							<h3>%1$s</h3>
							<p><strong>%2$s</strong> %3$s</p>
							<p><strong>%4$s</strong> %5$s</p>
							<hr>
							<p>%6$s</p>
							<p><a href="%7$s" class="button">%8$s</a> <a href="%9$s" class="button">%10$s</a></p>
						</div>',
						esc_html__( 'How to Set Up Your Homepage', 'medihealth' ),
						esc_html__( 'Step 1:', 'medihealth' ),
						esc_html__( 'Create pages or posts with titles, content, and featured images.', 'medihealth' ),
						esc_html__( 'Step 2:', 'medihealth' ),
						esc_html__( 'Go to other sections in this panel to enable them and select which pages/posts to display.', 'medihealth' ),
						esc_html__( 'Use "Icon" meta box for Services (Font Awesome class) and "Testimonial Designation" for Testimonials.', 'medihealth' ),
						esc_url( admin_url( 'post-new.php?post_type=page' ) ),
						esc_html__( 'Create Page', 'medihealth' ),
						esc_url( admin_url( 'post-new.php' ) ),
						esc_html__( 'Create Post', 'medihealth' )
					),
					'priority'    => 1,
					'panel'       => 'medihealth_theme_options',
				) );

				// Add a dummy setting for the guide section (required by WordPress)
				$wp_customize->add_setting( 'medihealth_setup_guide_dummy', array(
					'sanitize_callback' => 'sanitize_text_field',
				) );

				$wp_customize->add_control( 'medihealth_setup_guide_dummy', array(
					'section'     => 'medihealth_setup_guide_section',
					'type'        => 'hidden',
				) );

				/**
				 *	Load customizer options
				 */

				$dir = MEDIHEALTH_THEME_DIR .'/include/customizer/settings/';

				// Customizer files array
				$files = array(
					'general',
					'footer',
					'contact',
					'slider',
					'service', 
					'testimonial',
					'portfolio', 
					'blog',
					'meta-settings',
					);
				foreach ( $files as $key ) { require( $dir . $key .'.php' ); }
		}
	}

endif;

return new MediHealth_Customizer();