<?php
/*
 * The header for the head element and for displaying site title, tagline, logo and menu.
 */
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif; ?>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div id="container">
	<?php if ( is_page_template( 'page-full.php' ) || is_page_template( 'single-full.php' ) ) {
		$main_content = '#content-full';
	} else {
		$main_content = '#content';
	} ?>
	<a class="skip-link screen-reader-text" href="<?php echo esc_url( $main_content ); ?>"><?php esc_html_e( 'Skip to content', 'medical' ); ?></a>
	<div id="header">
		<div class="logo">
			<?php if ( get_theme_mod( 'medical_logo' ) ) : ?>
				<?php if ( get_theme_mod( 'medical_logo_width' ) ) {
					$logo_width = 'style="width:'.get_theme_mod( 'medical_logo_width' ).'px;"';
				} else {
					$logo_width = '';
				} ?>
				<div class="site-logo">
					<?php // phpcs:ignore ?>
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php bloginfo( 'name' ); ?>" rel="home"><img src="<?php echo esc_url( get_theme_mod( 'medical_logo' ) ); ?>" <?php echo wp_strip_all_tags( $logo_width, true ); ?> class="site-logo-img" alt="<?php bloginfo( 'name' ); ?>"></a>
				</div>
			<?php endif; ?>
			<?php if ( ( get_theme_mod( 'medical_site_title' ) != 'no' ) || ( get_theme_mod( 'medical_tagline' ) != 'no' ) ) : ?>
				<div class="site-title-tagline">
					<?php if ( get_theme_mod( 'medical_site_title' ) != 'no' ) : ?>
						<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php bloginfo( 'name' ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
					<?php endif; ?>
					<?php if ( get_theme_mod( 'medical_tagline' ) != 'no' ) : ?>
						<?php if ( get_bloginfo( 'description' ) ) : ?>
							<div class="site-tagline"><?php bloginfo( 'description' ); ?></div>
						<?php endif; ?>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		</div>
		<?php if ( has_nav_menu( 'primary' ) ) : ?>
			<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container_class' => 'nav-head' ) ); ?>
			<div class="mobile-nav-container">
				<?php if ( get_theme_mod( 'medical_mobile_menu_label' ) ) {
					$mobile_menu_label = get_theme_mod( 'medical_mobile_menu_label' );
				} else {
					$mobile_menu_label = __( 'Menu', 'medical' ).' &#43;';
				} ?>
				<button id="mobile-nav-toggle" class="mobile-nav-toggle"><?php echo esc_html( $mobile_menu_label ); ?></button>
				<div id="mobile-nav" class="mobile-nav">
					<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
				</div>
			</div>
		<?php endif; ?>
	</div>
	<div id="main">
		<?php if ( is_front_page() ) { ?>
			<?php get_template_part( 'content-homepage' ); ?>
		<?php } ?>
		<div id="main-content">
