<?php
/*
 * Theme functions and definitions.
 */

// Sets up theme defaults and registers various WordPress features that theme supports
function medical_setup() {
	// Set max content width for img, video, and more
	global $content_width;
	if ( ! isset( $content_width ) )
	$content_width = 760;

	// Register Menu
	register_nav_menus( array(
		'primary' => __( 'Primary Navigation', 'medical' ),
	) );

	// Add document title
	add_theme_support( 'title-tag' );

	// Add support for editor styles
	add_theme_support( 'editor-styles' );

	// Add editor styles
	add_editor_style( 'custom-editor-style.css' );

	// Custom header
	$header_args = array(
		'width' => 550,
		'height' => 350,
		'default-image' => get_template_directory_uri() . '/images/boats.jpg',
		'header-text' => false,
		'uploads' => true,
	);
	add_theme_support( 'custom-header', $header_args );

	// Default header
	register_default_headers( array(
		'boats' => array(
			'url' => get_template_directory_uri() . '/images/boats.jpg',
			'thumbnail_url' => get_template_directory_uri() . '/images/boats.jpg',
			'description' => __( 'Default header', 'medical' ),
		),
	) );

	// Post thumbnails
	add_theme_support( 'post-thumbnails' );

	// Resize thumbnails
	set_post_thumbnail_size( 300, 300 );

	// This feature adds RSS feed links to html head
	add_theme_support( 'automatic-feed-links' );

	// Switch default core markup for search form, comment form, comments and caption to output valid html5
	add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'caption' ) );

	// Background color and image
	$background_args = array(
		'default-color' => 'ffffff',
	);
	add_theme_support( 'custom-background', $background_args );

	// Post formats
	add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'gallery', 'audio' ) );
}
add_action( 'after_setup_theme', 'medical_setup' );

// Set max content width for full width page and post
function medical_extra_content_width() {
	global $content_width;
	if ( is_page_template( 'page-full.php' ) || is_page_template( 'single-full.php' ) )
	$content_width = 1100;
}
add_action( 'template_redirect', 'medical_extra_content_width' );

// Enqueues scripts and styles for front-end
function medical_scripts() {
	wp_enqueue_style( 'medical-style', get_stylesheet_uri() );
	wp_enqueue_script( 'medical-nav', get_template_directory_uri() . '/js/nav.js' );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'medical_scripts' );

// Widget areas
function medical_widgets_init() {
	register_sidebar( array(
		'name' => __( 'Primary Sidebar', 'medical' ),
		'id' => 'primary',
		'description' => __( 'You can add one or multiple widgets here.', 'medical' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	register_sidebar( array(
		'name' => __( 'Homepage Sidebar', 'medical' ),
		'id' => 'homepage',
		'description' => __( 'You can add one or multiple widgets here.', 'medical' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	register_sidebar( array(
		'name' => __( 'Footer Left', 'medical' ),
		'id' => 'footer-left',
		'description' => __( 'You can add one or multiple widgets here.', 'medical' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	register_sidebar( array(
		'name' => __( 'Footer Middle', 'medical' ),
		'id' => 'footer-middle',
		'description' => __( 'You can add one or multiple widgets here.', 'medical' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	register_sidebar( array(
		'name' => __( 'Footer Right', 'medical' ),
		'id' => 'footer-right',
		'description' => __( 'You can add one or multiple widgets here.', 'medical' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
}
add_action( 'widgets_init', 'medical_widgets_init' );

// Add class to post nav
function medical_post_next() {
	return 'class="nav-next"';
}
add_filter( 'next_posts_link_attributes', 'medical_post_next', 999 );

function medical_post_prev() {
	return 'class="nav-prev"';
}
add_filter( 'previous_posts_link_attributes', 'medical_post_prev', 999 );

// Add class to comment nav
function medical_comment_next() {
	return 'class="comment-next"';
}
add_filter( 'next_comments_link_attributes', 'medical_comment_next', 999 );

function medical_comment_prev() {
	return 'class="comment-prev"';
}
add_filter( 'previous_comments_link_attributes', 'medical_comment_prev', 999 );

// Custom excerpt lenght (default length is 55 words)
function medical_excerpt_length( $length ) { 
	if ( get_theme_mod( 'medical_content_lenght' ) ) {
		$length = get_theme_mod( 'medical_content_lenght' );
	}
	return $length;
}
add_filter( 'excerpt_length', 'medical_excerpt_length', 999 );

// Theme Customizer
function medical_theme_customizer( $wp_customize ) {
	$wp_customize->add_section( 'medical_logo_section', array(
		'title' => __( 'Logo', 'medical' ),
		'priority' => 30,
	) );
	$wp_customize->add_setting( 'medical_logo', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw',
	) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'medical_logo', array(
		'label' => __( 'Logo', 'medical' ),
		'section' => 'medical_logo_section',
		'settings' => 'medical_logo',
	) ) );
	$wp_customize->add_setting( 'medical_logo_width', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'medical_logo_width', array(
		'label' => __( 'Width', 'medical' ),
		'description' => __( 'Only numeric characters allowed.', 'medical' ),
		'section' => 'medical_logo_section',
		'settings' => 'medical_logo_width',
		'type' => 'number',
		'input_attrs' => array(
			'min' => 20,
			'max' => 1200,
			'step' => 20,
		),
	) ) );
	$wp_customize->add_section( 'medical_mobile_section', array(
		'title' => __( 'Mobile', 'medical' ),
		'priority' => 31,
	) );
	$wp_customize->add_setting( 'medical_mobile_menu_label', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'medical_mobile_menu_label', array(
		'label' => __( 'Menu label', 'medical' ),
		'section' => 'medical_mobile_section',
		'settings' => 'medical_mobile_menu_label',
		'input_attrs' => array(
			'placeholder' => __( 'Menu', 'medical' ).' &#43;',
		),
	) ) );
	$wp_customize->add_section( 'medical_blog_section', array(
		'title' => __( 'Blog', 'medical' ),
		'priority' => 32,
	) );
	$wp_customize->add_setting( 'medical_blog_title', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'medical_blog_title', array(
		'label' => __( 'Page title', 'medical' ),
		'section' => 'medical_blog_section',
		'settings' => 'medical_blog_title',
	) ) );
	$wp_customize->add_setting( 'medical_blog_content', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'wp_kses_post',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'medical_blog_content', array(
		'label' => __( 'Content', 'medical' ),
		'section' => 'medical_blog_section',
		'settings' => 'medical_blog_content',
		'type' => 'textarea',
	) ) );
	$wp_customize->add_setting( 'medical_content_type', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => 'yes',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'medical_content_type', array(
		'label' => __( 'Summary', 'medical' ),
		'section' => 'medical_blog_section',
		'settings' => 'medical_content_type',
		'type' => 'radio',
		'choices' => array(
			'yes' => __( 'Yes', 'medical' ),
			'no' => __( 'No', 'medical' ),
		),
	) ) );
	$wp_customize->add_setting( 'medical_content_lenght', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'medical_content_lenght', array(
		'label' => __( 'Summary lenght', 'medical' ),
		'description' => __( 'Only numeric characters allowed.', 'medical' ),
		'section' => 'medical_blog_section',
		'settings' => 'medical_content_lenght',
		'type' => 'number',
		'input_attrs' => array(
			'min' => 10,
			'max' => 100,
			'step' => 1,
			'placeholder' => '55',
		),
	) ) );
	$wp_customize->add_setting( 'medical_read_more', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => 'yes',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'medical_read_more', array(
		'label' => __( 'Read More button', 'medical' ),
		'section' => 'medical_blog_section',
		'settings' => 'medical_read_more',
		'type' => 'radio',
		'choices' => array(
			'yes' => __( 'Yes', 'medical' ),
			'no' => __( 'No', 'medical' ),
		),
	) ) );
	$wp_customize->add_setting( 'medical_read_more_label', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'medical_read_more_label', array(
		'label' => __( 'Read More label', 'medical' ),
		'section' => 'medical_blog_section',
		'settings' => 'medical_read_more_label',
		'input_attrs' => array(
			'placeholder' => __( 'Read More', 'medical' ).' &raquo;',
		),
	) ) );
	$wp_customize->add_setting( 'medical_post_image', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => 'no',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'medical_post_image', array(
		'label' => __( 'Featured image on single post page', 'medical' ),
		'section' => 'medical_blog_section',
		'settings' => 'medical_post_image',
		'type' => 'radio',
		'choices' => array(
			'yes' => __( 'Yes', 'medical' ),
			'no' => __( 'No', 'medical' ),
		),
	) ) );
	$wp_customize->add_section( 'medical_footer_section', array(
		'title' => __( 'Footer', 'medical' ),
		'priority' => 33,
	) );
	$wp_customize->add_setting( 'medical_footer_content', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'wp_kses_post',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'medical_footer_content', array(
		'label' => __( 'Copyright', 'medical' ),
		'section' => 'medical_footer_section',
		'settings' => 'medical_footer_content',
		'type' => 'textarea',
		'input_attrs' => array(
			'placeholder' => __( 'Copyright', 'medical' ).' '.gmdate( 'Y' ).' '.get_bloginfo( 'name' ),
		),
	) ) );
	// Site Identity section
	$wp_customize->add_setting( 'medical_site_title', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => 'yes',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'medical_site_title', array(
		'label' => __( 'Site Title', 'medical' ),
		'section' => 'title_tagline',
		'settings' => 'medical_site_title',
		'type' => 'radio',
		'choices' => array(
			'yes' => __( 'Yes', 'medical' ),
			'no' => __( 'No', 'medical' ),
		),
	) ) );
	$wp_customize->add_setting( 'medical_tagline', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => 'yes',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'medical_tagline', array(
		'label' => __( 'Tagline', 'medical' ),
		'section' => 'title_tagline',
		'settings' => 'medical_tagline',
		'type' => 'radio',
		'choices' => array(
			'yes' => __( 'Yes', 'medical' ),
			'no' => __( 'No', 'medical' ),
		),
	) ) );
}
add_action( 'customize_register', 'medical_theme_customizer' );
