<?php
add_action('wp_enqueue_scripts', 'mazino_theme_css', 999);
function mazino_theme_css()
{
    wp_enqueue_style('bootstrap', QUALITY_TEMPLATE_DIR_URI . '/css/bootstrap.css');
    wp_enqueue_style('mazino-parent-style', get_template_directory_uri() . '/style.css');
    wp_enqueue_style('mazino-theme-menu', QUALITY_TEMPLATE_DIR_URI . '/css/theme-menu.css');
    wp_enqueue_style('mazino-child-style', get_stylesheet_directory_uri() . '/style.css', array('parent-style'));
    wp_enqueue_script('mazino-mp-masonry-js', get_stylesheet_directory_uri() . '/js/masonry/mp.mansory.js');
}


add_action('after_setup_theme', 'mazino_setup');
function mazino_setup()
{
    //Load text domain for translation-ready
    load_theme_textdomain('mazino', get_stylesheet_directory() . '/languages');

    require(get_stylesheet_directory() . '/functions/customizer/customizer-copyright.php');

    add_theme_support( 'automatic-feed-links' );
    add_theme_support( 'title-tag' );
}

// Read more tag to formatting in blog page
    function mazino_new_content_more($more)
    {
        global $post;
        return '<div class="blog-btn-col"><a href="' . esc_url(get_permalink()) . "#more-{$post->ID}\" class=\"more-link\">Read More</a></div>";
    }
    add_filter('the_content_more_link', 'mazino_new_content_more');

function mazino_child_theme_setup()
{
    remove_filter('the_content_more_link', 'mazino_new_content_more');
    add_filter('the_content_more_link', 'mazino_new_content_more');

    if (is_admin()) {
        require get_stylesheet_directory() . '/admin/admin-init.php';
    }
}

add_action('after_setup_theme', 'mazino_child_theme_setup');

// footer custom script
function mazino_footer_custom_script()
{
    ?>
<script>
jQuery(document).ready(function ( jQuery ) {
	jQuery("#blog-masonry").mpmansory(
		{
			childrenClass: 'item', // default is a div
			columnClasses: 'padding', //add classes to items
			breakpoints:{
				lg: 4, //Change masonry column here like 2, 3, 4 column
				md: 6,
				sm: 12,
				xs: 12
			},
			distributeBy: { order: false, height: false, attr: 'data-order', attrOrder: 'asc' }, //default distribute by order, options => order: true/false, height: true/false, attr => 'data-order', attrOrder=> 'asc'/'desc'
			onload: function (items) {
				//make somthing with items
			}
		}
	);
});
</script>
<?php
}
add_action('wp_footer', 'mazino_footer_custom_script');


function mazino_default_data()
{
    return array(
    // general settings
    'footer_copyright_text' => '<p>'.__('Proudly powered by <a href="https://wordpress.org">WordPress</a> | Theme: <a href="https://webriti.com" rel="nofollow">Mazino</a> by Webriti', 'mazino').'</p>',
    );
}

/* Remove the parent theme section in child theme */
add_action('customize_register', 'mazino_remove_custom', 1000);
function mazino_remove_custom($wp_customize)
{
    $wp_customize->remove_section('theme_color');
}

$mazino_theme = wp_get_theme();
if( $mazino_theme->name == 'Mazino' || $mazino_theme->name == 'Mazino child' || $mazino_theme->name == 'Mazino Child' ) {
    // Notice to add required plugin
    function mazino_admin_plugin_notice_warn() {
        $screen = get_current_screen();
        if( $screen->id == 'themes'){
            $theme_name = wp_get_theme();
            if ( get_option( 'dismissed-mazino_comanion_plugin', false ) ) {
               return;
            }
            if ( function_exists('webriti_companion_activate')) {
                return;
            }?>

            <div class="updated notice is-dismissible mazino-theme-notice">

                <div class="owc-header">
                    <h2 class="theme-owc-title">               
                        <svg height="60" width="60" id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 70 70"><defs><style>.cls-1{font-size:33px;font-family:Verdana-Bold, Verdana;font-weight:700;}</style></defs><title>Artboard 1</title><text class="cls-1" transform="translate(-0.56 51.25)">WC</text></svg>
                        <?php echo esc_html('Webriti Companion','mazino');?>
                    </h2>
                </div>

                <div class="mazino-theme-content">
                    <h3><?php printf (esc_html__('Thank you for installing the %1$s theme.', 'mazino'), esc_html($theme_name)); ?></h3>

                    <p><?php esc_html_e( 'We highly recommend you to install and activate the', 'mazino' ); ?>
                        <b><?php esc_html_e( 'Webriti Companion', 'mazino' ); ?></b> plugin.
                        <br>
                        <?php esc_html_e( 'This plugin will unlock enhanced features to build a beautiful website.', 'mazino' ); ?>
                    </p>
                    <button id="install-plugin-button-welcome-page" data-plugin-url="<?php echo esc_url( 'https://webriti.com/extensions/webriti-companion.zip');?>"><?php echo esc_html__( 'Install', 'mazino' ); ?></button>
                </div>
            </div>
            
            <script type="text/javascript">
                jQuery(function($) {
                $( document ).on( 'click', '.mazino-theme-notice .notice-dismiss', function () {
                    var type = $( this ).closest( '.mazino-theme-notice' ).data( 'notice' );
                    $.ajax( ajaxurl,
                      {
                        type: 'POST',
                        data: {
                          action: 'dismissed_notice_handler',
                          type: type,
                        }
                      } );
                  } );
              });
            </script>
            <?php
        }
    }
    add_action( 'admin_notices', 'mazino_admin_plugin_notice_warn' );
    add_action( 'wp_ajax_dismissed_notice_handler', 'mazino_ajax_notice_handler');

    function mazino_ajax_notice_handler() {
        update_option( 'dismissed-mazino_comanion_plugin', TRUE );
    }

    function mazino_notice_style(){?>
        <style type="text/css">
            label.tg-label.breadcrumbs img {
                width: 6%;
                padding: 0;
            }
            .mazino-theme-notice .theme-owc-title{
                display: flex;
                align-items: center;
                height: 100%;
                margin: 0;
                font-size: 1.5em;
            }
            .mazino-theme-notice p{
                font-size: 14px;
            }
            .updated.notice.mazino-theme-notice h3{
                margin: 0;
            }
            div.mazino-theme-notice.updated {
                border-left-color: #ee591f;
            }
            .mazino-theme-content{
                padding: 0 0 1.2rem 3.57rem;
            }
        </style>
    <?php
    }
    add_action('admin_enqueue_scripts','mazino_notice_style');
}

// Hook the AJAX action for logged-in users
add_action('wp_ajax_mazino_check_plugin_status', 'mazino_check_plugin_status');

function mazino_check_plugin_status() {
    if (!current_user_can('install_plugins')) {
        wp_send_json_error('You do not have permission to manage plugins.');
        return;
    }

    if (!isset($_POST['plugin_slug'])) {
        wp_send_json_error('No plugin slug provided.');
        return;
    }

    $plugin_slug = sanitize_text_field($_POST['plugin_slug']);
    $plugin_main_file = $plugin_slug . '/' . $plugin_slug . '.php'; // Adjust this based on your plugin structure

    // Check if the plugin exists
    $plugins = get_plugins();
    if (isset($plugins[$plugin_main_file])) {
        if (is_plugin_active($plugin_main_file)) {
            wp_send_json_success(array('status' => 'activated'));
        } else {
            wp_send_json_success(array('status' => 'installed'));
        }
    } else {
        wp_send_json_success(array('status' => 'not_installed'));
    }
}

// Existing AJAX installation function for installing and activating
add_action('wp_ajax_mazino_install_activate_plugin', 'mazino_install_and_activate_plugin');

function mazino_install_and_activate_plugin() {
    if (!current_user_can('install_plugins')) {
        wp_send_json_error('You do not have permission to install plugins.');
        return;
    }

    if (!isset($_POST['plugin_url'])) {
        wp_send_json_error('No plugin URL provided.');
        return;
    }

    // Include necessary WordPress files for plugin installation
    include_once(ABSPATH . 'wp-admin/includes/file.php');
    include_once(ABSPATH . 'wp-admin/includes/misc.php');
    include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');

    $plugin_url = esc_url($_POST['plugin_url']);
    $plugin_slug = sanitize_text_field($_POST['plugin_slug']);
    $plugin_main_file = $plugin_slug . '/' . $plugin_slug . '.php'; // Ensure this matches your plugin structure

    // Download the plugin file
    WP_Filesystem();
    $temp_file = download_url($plugin_url);

    if (is_wp_error($temp_file)) {
        wp_send_json_error($temp_file->get_error_message());
        return;
    }

    // Unzip the plugin to the plugins folder
    $plugin_folder = WP_PLUGIN_DIR;
    $result = unzip_file($temp_file, $plugin_folder);
    
    // Clean up temporary file
    unlink($temp_file);

    if (is_wp_error($result)) {
        wp_send_json_error($result->get_error_message());
        return;
    }

    // Activate the plugin if it was installed
    $activate_result = activate_plugin($plugin_main_file);

    

    // Return success with redirect URL
    wp_send_json_success(array('redirect_url' => admin_url('admin.php?page=mazino-welcome')));
}

// Enqueue JavaScript for the button functionality
add_action('admin_enqueue_scripts', 'mazino_enqueue_plugin_installer_script',11);

function mazino_enqueue_plugin_installer_script(){
    global $hook_suffix;
    wp_dequeue_script('quality-plugin-installer-js');
    wp_enqueue_script('mazino-plugin-installer-js',  get_stylesheet_directory_uri() . '/admin/assets/js/plugin-installer.js', array('jquery'), null, true);
    wp_localize_script('mazino-plugin-installer-js', 'pluginInstallerAjax', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'hook_suffix' => $hook_suffix,
        'nonce' => wp_create_nonce('plugin_installer_nonce'),

    ));
}