<?php
/**
 * Template part for displaying posts
 *
 */

?>


<article id="post-<?php the_ID(); ?>" <?php post_class('entry'); ?>>

  	<?php if ( '' !== get_the_post_thumbnail()) : ?>
  	<div class="entry-img">
	    <div class="post-thumbnail">
		    <a href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail('maximgym-featured-image');?>
			</a>
		</div>
  	</div>
  	<?php endif; ?>
    <?php
  	if ( is_single() ) {
		the_title( '<h1 class="entry-title mt-5 mb-4">', '</h1>' );
	} elseif ( is_front_page() && is_home() ) {
		the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
	} else {
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
	}
	
	if ( 'post' === get_post_type() ) {
		echo '<div class="entry-meta">';
		if ( is_single() ) {
			maximgym_posted_on();
		} else {
			echo maximgym_time_link();
			maximgym_edit_link();
		}
		echo '</div>';
	}
	?>
  	
  	<div class="entry-content text-justify">
	   <?php
			the_content(
				sprintf(
					/* translators: %s: Post title. Only visible to screen readers. */
					__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'maximgym' ),
					get_the_title()
				)
			);

			wp_link_pages(
				array(
					'before'      => '<div class="page-links">' . __( 'Pages:', 'maximgym' ),
					'after'       => '</div>',
					'link_before' => '<span class="page-number">',
					'link_after'  => '</span>',
				)
			);
		?>
  	</div>
  	<?php
	if ( is_single() ) {
		maximgym_entry_footer();
	}
	?>
</article><!-- End blog entry -->

