<?php
/**
 * The template for displaying all single posts
 *
 */

get_header(); ?>

<div class="wrap">
	<div id="primary" class="content-area">
		<main id="main" class="site-main">
			<div class="container">
				<div class="row">
					<div class="col-md-8">
		          		<?php
						// Start the Loop.
						while ( have_posts() ) :
							the_post();

							get_template_part( 'template-parts/post/content', get_post_format() );

							// If comments are open or we have at least one comment, load up the comment template.
							if ( comments_open() || get_comments_number() ) :
								comments_template();
							endif;

							the_post_navigation(
								array(
									
									'prev_text' => '<span class="screen-reader-text">' . __( 'Previous Post', 'maximgym' ) . '</span><span aria-hidden="true" class="nav-subtitle">' . __( 'Previous', 'maximgym' ) . '</span> <span class="nav-title mt-1 mb-5" style="display:block;"><span class="nav-title-icon-wrapper"><i class="bi bi-arrow-left"></i></span> %title</span>',
									
									'next_text' => '<span class="screen-reader-text">' . __( 'Next Post', 'maximgym' ) . '</span><span aria-hidden="true" class="nav-subtitle">' . __( 'Next', 'maximgym' ) . '</span> <span class="nav-title mt-1 mb-5" style="display:block;"> %title <span class="nav-title-icon-wrapper"><i class="bi bi-arrow-right"></i></span></span>',
								)
							);

						endwhile; // End the loop.
					?>
					</div>
					<div class="col-md-4">
						<div id="maximgym-blog-sidebar-wrapper" class="p-4 bg-white shadow-lg p-3 mt-5 mb-5 bg-body rounded">
							<?php get_sidebar(); ?>
						</div>
					</div>
				</div>
			</div>
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- .wrap -->

<?php get_footer();?>
