<?php
/**
 * Template for displaying search forms in maximgym
 *
 */

?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label for="search">
		<span class="screen-reader-text">
			<?php
			echo _x( 'Search for:', 'label', 'maximgym' );
			?>
		</span>
	</label>
	<div class="input-group">
	  <input type="search" id="search" name="s" class="form-control" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'maximgym' ); ?>" value="<?php echo get_search_query(); ?>" aria-label="Search" aria-describedby="search-addon" />
	
	  	<button type="submit" class="btn search-submit maximgym-bg-orange text-white">
		  	<i class="bi bi-search"></i>
		  	<span class="screen-reader-text">
				<?php echo _x( 'Search', 'submit button', 'maximgym' );?>
			</span>
		</button>
	</div>
</form>
