<?php
/**
 * The template for displaying search results pages
 *
 */

get_header();?>

<div class="wrap">
    
	<header class="page-header">
		<?php get_search_form();?>
	</header><!-- .page-header -->

	<div id="primary" class="content-area">
		<main id="main" class="site-main">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<?php if ( have_posts() ) : ?>
							<h1 class="page-title px-3 text-center">
							<?php
							/* translators: Search query. */
							printf( __( 'Search Results for: %s', 'maximgym' ), '<span>' . get_search_query() . '</span>' );
							?>
							</h1>
						<?php else : ?>
							<h1 class="page-title text-center"><?php _e( 'Nothing Found', 'maximgym' ); ?></h1>
						<?php endif; ?>
						<?php
						if ( have_posts() ) :
							// Start the Loop.
							while ( have_posts() ) :
								the_post();
								get_template_part( 'template-parts/post/content', 'excerpt' );

							endwhile;
							the_posts_pagination(
									array(
										
										'prev_text'          => '<i class="bi bi-arrow-left"></i>' . '<span class="screen-reader-text">' . __( 'Previous page', 'maximgym' ) . '</span>',
										
										'next_text'          => '<span class="screen-reader-text">' . __( 'Next page', 'maximgym' ) . '</span>' . '<i class="bi bi-arrow-right"></i>' ,
										
										'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'maximgym' ) . ' </span>',
									)
								);

						else :?>
							<p><?php _e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'maximgym' ); ?></p>
						<?php
						endif;
						?>
					</div>
				</div>
			</div>
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- .wrap -->

<?php get_footer();?>