<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 */

get_header(); ?>

<div class="wrap">
  	<?php if ( is_home() && ! is_front_page() ) : ?>
		<header class="page-header">
			<h1 class="page-title text-center mt-3"><?php single_post_title(); ?></h1>
		</header>
	<?php else : ?>
	<header class="page-header mt-3 mb-3 p-0 p-3 text-center">
		<h2 class="page-title text-center mt-3"><?php _e( 'Posts', 'maximgym' ); ?></h2>
	</header>
	<?php endif; ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main">
			<div class="container">
				<div class="row">
					<div class="col-md-8">
						<?php
						if ( have_posts() ) :
							// Start the Loop.
							while ( have_posts() ) :
								the_post();
								get_template_part( 'template-parts/post/content', get_post_format() );

							endwhile;

							the_posts_pagination(
								array(
									
									'prev_text'          => '<i class="bi bi-arrow-left"></i><span class="screen-reader-text">' . __( 'Previous page', 'maximgym' ) . '</span>',
									
									'next_text'          => '<span class="screen-reader-text">' . __( 'Next page', 'maximgym' ) . ' </span><i class="bi bi-arrow-right"></i>',
									
									'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'maximgym' ) . ' </span>',
								)
							);

						else :
							get_template_part( 'template-parts/post/content', 'none' );

						endif;
						?>
					</div>
					<div class="col-md-4">
						<div id="maximgym-blog-sidebar-wrapper" class="p-4 bg-white shadow-lg p-3 mb-5 bg-body rounded">
							<?php get_sidebar(); ?>
						</div>
					</div>
				</div>
			</div>
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- .wrap -->
<?php
get_footer();