<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <meta content="" name="description">
  <meta content="" name="keywords">
  <link rel="profile" href="http://gmpg.org/xfn/11" />

  <?php wp_head();?>

</head>

<body <?php body_class(); ?>>
  <?php wp_body_open(); ?>
  
  <div id="page" class="site">
      <a class="skip-link screen-reader-text" href="#content">
        <?php
        /* translators: Hidden accessibility text. */
        _e( 'Skip to content', 'maximgym' );
        ?>
      </a>
      <!-- ======= Top Bar ======= -->
      <section id="topbar" class="d-flex align-items-center">
        <?php 
          $contact_email_address = get_theme_mod('set_header_email',__('contact@example.com','maximgym'));
          $contact_number = get_theme_mod('set_header_phone',__('5589 55488 55','maximgym'));
        ?>
        <div class="container d-flex justify-content-center justify-content-md-between">
          <div class="contact-info d-flex align-items-center">
            <?php 
              if($contact_email_address != null || $contact_email_address != ''){
             ?>
                <i class="bi bi-envelope d-flex align-items-center">
                  <a href="mailto:<?php echo esc_html($contact_email_address);?>">
                    <?php echo esc_html($contact_email_address);?>
                  </a>
                </i>
            <?php 
              }
              if($contact_number != null || $contact_number != ''){
            ?>
                <i class="bi bi-phone d-flex align-items-center ms-4"><span>+1 <?php echo esc_html($contact_number);?></span></i>
            <?php 
              }
            ?>
          </div>
          <div class="social-links d-none d-md-flex align-items-center">
            <?php if ( get_theme_mod( 'twitter' ) ): ?>
                  <a class="light-text" href="<?php echo esc_url(get_theme_mod( 'twitter' )); ?>" target="_blank">
                      <i class="bi bi-twitter-x"></i></i>
                  </a>
              <?php endif; ?>
              <?php if ( get_theme_mod( 'instagram' ) ): ?>
                  <a class="light-text" href="<?php echo esc_url(get_theme_mod( 'instagram' )); ?>" target="_blank">
                      <i class="bi bi-instagram"></i></i>
                  </a>
              <?php endif; ?>
              <?php if ( get_theme_mod( 'facebook' ) ): ?>
                  <a class="light-text" href="<?php echo esc_url(get_theme_mod( 'facebook' )); ?>" target="_blank">
                      <i class="bi bi-facebook"></i></i>
                  </a>
              <?php endif; ?>
              <?php if ( get_theme_mod( 'skype' ) ): ?>
                  <a class="light-text" href="<?php echo esc_url(get_theme_mod( 'skype' )); ?>" target="_blank">
                      <i class="bi bi-skype"></i></i>
                  </a>
              <?php endif; ?>
              <?php if ( get_theme_mod( 'linkedin' ) ): ?>
                  <a class="light-text" href="<?php echo esc_url(get_theme_mod( 'linkedin' )); ?>" target="_blank">
                      <i class="bi bi-linkedin"></i></i>
                  </a>
              <?php endif; ?>
            
          </div>
        </div>
      </section>

      <!-- ======= Header ======= -->
      <header id="header" class="d-flex align-items-center w-100">
        <div class="container d-flex justify-content-between">
          <?php get_template_part( 'template-parts/navigation/navigation', 'top' ); ?>
        </div>
      </header><!-- End Header -->

      
      <div class="site-content-contain position-relative">
            <div id="content" class="site-content">
