<?php
/**
 * maximgym functions and definitions
 *
 *
 */

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */

if ( ! isset ( $content_width) ) {
    $content_width = 800;
}

if(!(function_exists('maximgym_theme_setup'))){

  function maximgym_theme_setup() {

      load_theme_textdomain('maximgym',get_template_directory().'/languages/');

      add_theme_support( 'automatic-feed-links' );

      add_theme_support( 'title-tag' );

      add_theme_support( 'post-thumbnails' );

      add_theme_support( 'custom-background');

       $customLogo = array(
          'height'               => 100,
          'width'                => 400,
          'flex-height'          => true,
          'flex-width'           => true,
          'header-text'          => array( 'site-title', 'site-description' ),
          'unlink-homepage-logo' => true
      );

      add_theme_support( 'custom-logo', $customLogo);

      add_theme_support( 'custom-header' );

      add_theme_support( 'maximgym-featured-image' );

      add_theme_support( 'post-formats',  array( 'aside', 'gallery', 'quote', 'image', 'video' ) );

      add_theme_support( 'responsive-embeds' );

      register_nav_menus(
        array(
            'main-menu'    => __( 'Main Menu', 'maximgym' ),
            'social' => __( 'Social Links Menu', 'maximgym' ),
          )
        );
  }
}

add_action( 'after_setup_theme', 'maximgym_theme_setup' );


/**
 * Enqueues scripts and styles.
 */
if(!(function_exists('maximgym_styles'))){

  function maximgym_styles() {

    $theme_version = wp_get_theme()->get( 'Version' );
    wp_enqueue_style( 'google-font', 'https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Muli:300,300i,400,400i,500,500i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i');
    
    wp_enqueue_style( 'boostrap', get_template_directory_uri().'/assets/vendor/bootstrap/css/bootstrap.css');
    wp_enqueue_style( 'boostrap-icon', get_template_directory_uri().'/assets/bootstrap-icons-1.11.3/font/bootstrap-icons.css');
    wp_enqueue_style( 'box-icon', get_template_directory_uri().'/assets/vendor/boxicons/css/boxicons.min.css');
    wp_enqueue_style( 'maximgym-blog', get_template_directory_uri().'/assets/css/blogstyle.css', array(), $theme_version);
    wp_enqueue_style( 'maximgym-general', get_template_directory_uri().'/assets/css/general.css', array(), $theme_version);
    wp_enqueue_style( 'maximgym-style', get_stylesheet_uri(), array(), $theme_version);
  
  }
}

add_action( 'wp_enqueue_scripts', 'maximgym_styles' );

/**
 * Enqueue Script. *
 */
if(!(function_exists('maximgym_scripts'))){

  function maximgym_scripts() {
      $theme_version = wp_get_theme()->get( 'Version' );
      wp_enqueue_script( 'bootstrap-bundle',get_template_directory_uri().'/assets/vendor/bootstrap/js/bootstrap.bundle.js', array('jquery'), $theme_version);

      
      wp_enqueue_script( 'maximgym-navigation',get_template_directory_uri().'/assets/js/navigation.js', array('jquery'), $theme_version);
      wp_enqueue_script( 'maximgym-common',get_template_directory_uri().'/assets/js/common.js', array('jquery'), $theme_version);

      

      wp_enqueue_script( 'maximgym-skip-link-focus-fix', get_theme_file_uri( '/assets/js/skip-link-focus-fix.js' ), array(), '1.0', true );

      if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
      }
  }

}


add_action( 'wp_enqueue_scripts', 'maximgym_scripts' );


function maximgym_skip_link_focus_fix() {
  // The following is minified via `terser --compress --mangle -- js/skip-link-focus-fix.js`.
  ?>
  <script>
  /(trident|msie)/i.test(navigator.userAgent)&&document.getElementById&&window.addEventListener&&window.addEventListener("hashchange",function(){var t,e=location.hash.substring(1);/^[A-z0-9_-]+$/.test(e)&&(t=document.getElementById(e))&&(/^(?:a|select|input|button|textarea)$/i.test(t.tagName)||(t.tabIndex=-1),t.focus())},!1);
  </script>
  <?php
}

add_action( 'wp_print_footer_scripts', 'maximgym_skip_link_focus_fix' );

/**
 * Register widget area.
 *
 */
if(!(function_exists('maximgym_widgets_init'))){
  function maximgym_widgets_init() { 

    register_sidebar(
      array(
        'name'          => __( 'Blog Sidebar', 'maximgym' ),
        'id'            => 'sidebar-1',
        'description'   => __( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'maximgym' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="sidebar-title">',
        'after_title'   => '</h3>',
      )
    );

  }

}

add_action( 'widgets_init', 'maximgym_widgets_init' );

if ( ! function_exists( 'maximgym_front_page_template' ) ) {
  function maximgym_front_page_template( $template ) {
    return is_home() ? '' : $template;
  }
}

add_filter( 'frontpage_template', 'maximgym_front_page_template' );

if ( ! function_exists( 'maximgym_edit_link' ) ) {  
    function maximgym_edit_link(){
      edit_post_link(
        sprintf(
          /* translators: %s: Post title. Only visible to screen readers. */
          __( '<i class="bi bi-pencil-square"></i> Edit<span class="screen-reader-text"> "%s"</span>', 'maximgym' ),
          get_the_title()
        ),
        '<span class="edit-link px-2 float-end">',
        '</span>'
      );
  }

}


if ( ! function_exists( 'maximgym_entry_footer' ) ) { 

    function maximgym_entry_footer(){
      $separate_meta = wp_get_list_item_separator();

      // Get Categories for posts.
      $categories_list = get_the_category_list( $separate_meta );

      // Get Tags for posts.
      $tags_list = get_the_tag_list( '', $separate_meta );
      if ( ( ( maximgym_categorized_blog() && $categories_list ) || $tags_list ) || get_edit_post_link() ) {
        echo '<footer class="entry-footer">';

      if ( 'post' === get_post_type() ) {
        if ( ( $categories_list && maximgym_categorized_blog() ) || $tags_list ) {
          echo '<span class="cat-tags-links">';

          // Make sure there's more than one category before displaying.
          if ( $categories_list && maximgym_categorized_blog() ) {
            echo '<span class="cat-links"><i class="bi bi-folder2-open"></i>'.
              /* translators: Hidden accessibility text. */
              '<span class="screen-reader-text">' . __( 'Categories', 'maximgym' ) . '</span>' .
              $categories_list .
            '</span>';
          }

          if ( $tags_list && ! is_wp_error( $tags_list ) ) {
            echo '<span class="tags-links"><i class="bi bi-hash"></i>'.
              /* translators: Hidden accessibility text. */
              '<span class="screen-reader-text">' . __( 'Tags', 'maximgym' ) . '</span>' .
              $tags_list .
            '</span>';
          }

          echo '</span>';
        }
      }

      maximgym_edit_link();

      echo '</footer> <!-- .entry-footer -->';

      }

    }

  }

  if ( ! function_exists( 'maximgym_categorized_blog' ) ) {

    function maximgym_categorized_blog() {
      $category_count = get_transient( 'maximgym_categories' );

      if ( false === $category_count ) {
        // Create an array of all the categories that are attached to posts.
        $categories = get_categories(
          array(
            'fields'     => 'ids',
            'hide_empty' => 1,
            // We only need to know if there is more than one category.
            'number'     => 2,
          )
        );

        // Count the number of categories that are attached to the posts.
        $category_count = count( $categories );

        set_transient( 'maximgym_categories', $category_count );
      }

      // Allow viewing case of 0 or 1 categories in post preview.
      if ( is_preview() ) {
        return true;
      }

      return $category_count > 1;
  }

}

if ( ! function_exists( 'maximgym_posted_on' ) ) {
  
  function maximgym_posted_on() {
    // Get the author name; wrap it in a link.
    $byline = sprintf(
      /* translators: %s: Post author. */
      __( 'by %s', 'maximgym' ),
      '<i class="bi bi-person"></i><span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . get_the_author() . '</a></span>'
    );

    // Finally, let's write all of this to the page.
    echo '<span class="posted-on"> <i class="bi bi-clock"></i>' . maximgym_time_link() . '</span><span class="byline"> ' . $byline . '</span>';

  }

}


if ( ! function_exists( 'maximgym_time_link' ) ) {

  function maximgym_time_link() {

    $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
    if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
      $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
    }

    $time_string = sprintf(
      $time_string,
      get_the_date( DATE_W3C ),
      get_the_date(),
      get_the_modified_date( DATE_W3C ),
      get_the_modified_date()
    );

    // Wrap the time string in a link, and preface it with 'Posted on'.
    return sprintf(
      /* translators: %s: Post date. */
      __( '<span class="screen-reader-text">Posted on</span> %s', 'maximgym' ),
      '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
    );

  }

}

if ( ! function_exists( 'maximgym_is_frontpage' ) ) {

  function maximgym_is_frontpage() {
    return ( is_front_page() && ! is_home() );
  }

}




require get_parent_theme_file_path( '/inc/maximgym-navbar-walker.php' ); 

require get_parent_theme_file_path( '/inc/customizer.php' ); 
