<?php get_header();?>
  <main id="main" class="maximgym-customiser-option">

           <!-- ======= Hero Section ======= -->
          <section id="hero" class="maximgym-customiser-option">
            <?php 
           
              $hero_title = get_theme_mod('set_hero_title','Add the title');
              $hero_subtitle = get_theme_mod('set_hero_subtitle','Add subTitle');
              $hero_button_text = get_theme_mod('set_hero_button_text','Read More');
              $hero_button_link = esc_url(get_theme_mod('set_hero_button_link','#'));
              $hero_button_height = get_theme_mod('set_hero_height',800);
              $hero_background_image = get_theme_mod('set_hero_background',get_parent_theme_file_uri( '/assets/images/hero_image.jpg' ));
            ?>
            <div  style="background:url('<?php echo $hero_background_image;?>') center no-repeat;height:<?php echo $hero_button_height;?>px;">
              <div class="carousel-container">
                    <div class="carousel-content animate__animated animate__fadeInUp">
                    <h2><?php echo esc_html($hero_title);?></h2>
                    <p><?php echo esc_html($hero_subtitle);?></p>
                    <div class="text-center"><a href="<?php echo $hero_button_link;?>" class="btn-get-started"><?php echo esc_html($hero_button_text);?></a></div>
                  </div>
              </div>
            </div>
           
          </section><!-- End Hero -->

    <!-- ======= Cta Section ======= -->
    <section id="cta" class="cta slideanim">
      <?php 
        $cta_title = get_theme_mod('set_cta_title','Gym Excercise equipments');
        $cta_subtitle = get_theme_mod('set_cta_subtitle','Add Brief Desctiption');
        $cta_button_text = get_theme_mod('set_cta_button_text','Read More');
        $cta_button_link = esc_url(get_theme_mod('set_cta_button_link','#'));
      ?>
      <div class="container">

        <div class="row">
          <div class="col-lg-9 text-center text-lg-left">
            <h3><?php echo esc_html($cta_title);?></h3>
            <p><?php echo esc_html($cta_subtitle);?></p>
          </div>
          <div class="col-lg-3 cta-btn-container text-center">
            <a class="cta-btn align-middle" href="<?php echo $cta_button_link;?>"><?php echo esc_html($cta_button_text);?></a>
          </div>
        </div>

      </div>
    </section><!-- End Cta Section -->

    <!-- ======= Services Section ======= -->
    <section id="services" class="services slideanim">
      <?php 
        $service_title = get_theme_mod('set_service_title','Services');
        $service_subtitle = get_theme_mod('set_service_subtitle','The passage experienced a surge in popularity during the 1960s.');

        $service_first_icon = get_theme_mod('set_service_first_icon','<i class="bi bi-briefcase"></i>');
        $service_first_title = get_theme_mod('set_service_title_first','Add Title');
        $service_first_subtitle = get_theme_mod('set_service_subtitle_first','Add SubTitle');

        $service_sec_icon = get_theme_mod('set_service_sec_icon','<i class="bi bi-card-checklist"></i>');
        $service_sec_title = get_theme_mod('set_service_title_sec','Add Title');
        $service_sec_subtitle = get_theme_mod('set_service_subtitle_sec','Add SubTitle');

        $service_third_icon = get_theme_mod('set_service_third_icon','<i class="bi bi-bar-chart"></i>');
        $service_third_title = get_theme_mod('set_service_title_third','Add Title');
        $service_third_subtitle = get_theme_mod('set_service_subtitle_third','Add SubTitle');
      ?>
      <div class="container">
        <div class="section-title" data-aos="fade-up">
          <h2><strong><?php echo esc_html($service_title);?></strong></h2>
          <p><?php echo esc_html($service_subtitle);?></p>
        </div>
        <div class="row">
          <div class="col-lg-4 col-md-6">
            <div class="icon-box" data-aos="fade-up">
              <div class="icon"><?php echo $service_first_icon;?></div>
              <h4 class="title"><a href=""><?php echo esc_html($service_first_title);?></a></h4>
              <p class="description"><?php echo esc_html($service_first_subtitle);?></p>
            </div>
          </div>
          <div class="col-lg-4 col-md-6">
            <div class="icon-box" data-aos="fade-up" data-aos-delay="100">
              <div class="icon"><?php echo $service_sec_icon;?></div>
              <h4 class="title"><a href=""><?php echo esc_html($service_sec_title);?></a></h4>
              <p class="description"><?php echo esc_html($service_sec_subtitle);?></p>
            </div>
          </div>
          <div class="col-lg-4 col-md-6">
            <div class="icon-box" data-aos="fade-up" data-aos-delay="200">
              <div class="icon"><?php echo $service_third_icon;?></div>
              <h4 class="title"><a href=""><?php echo esc_html($service_third_title);?></a></h4>
              <p class="description"><?php echo esc_html($service_third_subtitle);?></p>
            </div>
          </div>
        </div>

      </div>
    </section><!-- End Services Section -->

    <!-- ======= Portfolio Section ======= -->
    <section id="portfolio" class="portfolio slideanim">
      <?php 
        
        $portfolio_title = get_theme_mod('set_portfolio_title','Portfolio');
        $portfolio_subtitle = get_theme_mod('set_portfolio_subtitle','Add subTitle');

        $portfolio_first_image = get_theme_mod('set_portfolio_first_image');
        $portfolio_first_image_title = get_theme_mod('set_portfolio_first_image_title','App 1');
       

        $portfolio_sec_image = get_theme_mod('set_portfolio_sec_image');
        $portfolio_sec_image_title = get_theme_mod('set_portfolio_sec_image_title','App 2');
        
        $portfolio_third_image = get_theme_mod('set_portfolio_third_image');
        $portfolio_third_image_title = get_theme_mod('set_portfolio_third_image_title','App 3');
        
        $portfolio_fourth_image = get_theme_mod('set_portfolio_fourth_image');
        $portfolio_fourth_image_title = get_theme_mod('set_portfolio_fourth_image_title','App 4');
        
        $portfolio_fifth_image = get_theme_mod('set_portfolio_fifth_image');
        $portfolio_fifth_image_title = get_theme_mod('set_portfolio_fifth_image_title','App 5');
        
        $portfolio_sixth_image = get_theme_mod('set_portfolio_sixth_image');
        $portfolio_sixth_image_title = get_theme_mod('set_portfolio_sixth_image_title','App 6');
        
      ?>
      <div class="container">
        <div class="section-title" data-aos="fade-up">
          <h2><strong><?php echo esc_html($portfolio_title);?></strong></h2>
          <p><?php echo esc_html($portfolio_subtitle);?></p>
        </div>
        <div class="row" data-aos="fade-up">
          <div class="col-lg-12 d-flex justify-content-center">
            <ul id="portfolio-flters">
              <li data-filter="*" class="filter-active"><?php _e('Portfolio','maximgym');?></li>
            </ul>
          </div>
        </div>

        <div class="row portfolio-container" data-aos="fade-up">
          <?php
          
          if($portfolio_first_image != null || $portfolio_first_image != ''){
          ?>
          <div class="col-lg-4 col-md-6 portfolio-item filter-app">
            <a title="<?php echo $portfolio_first_image_title;?>" href="<?php echo esc_url($portfolio_first_image);?>">
              <img src="<?php echo esc_url($portfolio_first_image);?>" class="img-fluid" alt="">
            </a>
          </div>
          <?php 
            }
            if($portfolio_sec_image != null || $portfolio_sec_image != ''){
           ?>
          <div class="col-lg-4 col-md-6 portfolio-item filter-web">
            <a title="<?php echo $portfolio_sec_image_title;?>" href="<?php echo esc_url($portfolio_sec_image);?>">
              <img src="<?php echo esc_url($portfolio_sec_image);?>" class="img-fluid" alt="">
            </a>
          </div>
          <?php 
            }
            if($portfolio_third_image != null || $portfolio_third_image != ''){
           ?>

          <div class="col-lg-4 col-md-6 portfolio-item filter-app">
            <a title="<?php echo $portfolio_third_image_title;?>" href="<?php echo esc_url($portfolio_third_image);?>">
              <img src="<?php echo esc_url($portfolio_third_image);?>" class="img-fluid" alt="">
            </a>
          </div>
           <?php 
            }
            if($portfolio_fourth_image != null || $portfolio_fourth_image != ''){
           ?>
          <div class="col-lg-4 col-md-6 portfolio-item filter-card">
            <a title="<?php echo $portfolio_fourth_image_title;?>" href="<?php echo esc_url($portfolio_fourth_image);?>">
              <img src="<?php echo esc_url($portfolio_fourth_image);?>" class="img-fluid" alt="">
            </a>
          </div>
           <?php 
            }
            if($portfolio_fifth_image != null || $portfolio_fifth_image != ''){
           ?>
          <div class="col-lg-4 col-md-6 portfolio-item filter-web">
            <a title="<?php echo $portfolio_fifth_image_title;?>" href="<?php echo esc_url($portfolio_fifth_image);?>">
              <img src="<?php echo esc_url($portfolio_fifth_image);?>" class="img-fluid" alt="">
            </a>
          </div>
           <?php 
            }
            if($portfolio_sixth_image != null || $portfolio_sixth_image != ''){
           ?>
          <div class="col-lg-4 col-md-6 portfolio-item filter-app">
            <a title="<?php echo $portfolio_sixth_image_title;?>" href="<?php echo esc_url($portfolio_sixth_image);?>">
              <img src="<?php echo $portfolio_sixth_image;?>" class="img-fluid" alt="">
            </a>
          </div>
           <?php 
            }
           ?>
        </div>
      </div>
    </section><!-- End Portfolio Section -->

    <!-- ======= Our Clients Section ======= -->
    <section id="clients" class="clients slideanim">
      <?php 
     
        $client_title = get_theme_mod('set_client_title','Our Clients');
        $client_subtitle = get_theme_mod('set_client_subtitle','It difficult to find examples of lorem ipsum in use before Letraset made it popular.');
        
        $client_brand_logo_first = esc_url(get_theme_mod('set_client_brand_first_image'));
        $client_brand_logo_second = esc_url(get_theme_mod('set_client_brand_sec_image'));
        $client_brand_logo_third = esc_url(get_theme_mod('set_client_brand_third_image'));
        $client_brand_logo_fourth = esc_url(get_theme_mod('set_client_brand_fourth_image'));
      ?>
      <div class="container">

        <div class="section-title" data-aos="fade-up">
          <h2><?php echo esc_html($client_title);?></h2>
          <p><?php echo esc_html($client_subtitle);?></p>
        </div>

        <div class="row no-gutters clients-wrap clearfix" data-aos="fade-up">

          <?php 
            if(isset($client_brand_logo_first) && $client_brand_logo_first!=''){
          ?>
          <div class="col-lg-3 col-md-4 col-xs-6">
            <div class="client-logo">
              <img src="<?php echo $client_brand_logo_first;?>" class="img-fluid" width="83" height="36" alt="brand logo">
            </div>
          </div>
          <?php 
            }
            if(isset($client_brand_logo_second) && $client_brand_logo_second!=''){

          ?>

          <div class="col-lg-3 col-md-4 col-xs-6">
            <div class="client-logo">
              <img src="<?php echo $client_brand_logo_second;?>" class="img-fluid" width="83" height="36" alt="brand logo">
            </div>
          </div>
          <?php 
            }
            if(isset($client_brand_logo_third) && $client_brand_logo_third!=''){

          ?>
          <div class="col-lg-3 col-md-4 col-xs-6">
            <div class="client-logo">
              <img src="<?php echo $client_brand_logo_third;?>" class="img-fluid" width="83" height="36" alt="brand logo">
            </div>
          </div>
          <?php 
            }
            if(isset($client_brand_logo_fourth) && $client_brand_logo_fourth!=''){

          ?>
          <div class="col-lg-3 col-md-4 col-xs-6">
            <div class="client-logo">
              <img src="<?php echo $client_brand_logo_fourth;?>" class="img-fluid" width="83" height="36" alt="brand logo">
            </div>
          </div>
          <?php 
            }
          ?>
        </div>

      </div>
    </section><!-- End Our Clients Section -->

  </main><!-- End #main -->

<?php get_footer();?>
