<?php
/**
 * The template for displaying archive pages
 *
*/

get_header(); ?>

<div class="wrap">
	
	<?php if ( have_posts() ) : ?>
		<header class="page-header mt-5 px-3">
			<?php
				the_archive_title( '<h1 class="page-title">', '</h1>' );
				the_archive_description( '<div class="taxonomy-description">', '</div>' );
			?>
		</header><!-- .page-header -->
	<?php endif; ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main">
			<div class="container">
				<div class="row">
					<div class="col-md-8">
						<?php
						if ( have_posts() ) :
							?>
							<?php
							// Start the Loop.
							while ( have_posts() ) :
								the_post();
								get_template_part( 'template-parts/post/content', get_post_format() );

							endwhile;

							the_posts_pagination(
								array(
									'prev_text'          => '<i class="bi bi-arrow-left"></i>' . '<span class="screen-reader-text">' . __( 'Previous page', 'maximgym' ) . '</span>',
									
									'next_text'          => '<span class="screen-reader-text">' . __( 'Next page', 'maximgym' ) . '</span>' . '<i class="bi bi-arrow-right"></i>',
									
									'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'maximgym' ) . ' </span>',
								)
							);

						else :

							get_template_part( 'template-parts/post/content', 'none' );

						endif;
						?>
					</div>	
					<div class="col-md-4">
						<div id="maximgym-blog-sidebar-wrapper" class="p-4 bg-white shadow-lg p-3 mb-5 bg-body rounded" style="border:solid 1px #ccc;">
							<?php get_sidebar(); ?>
						</div>
					</div>
				</div><!-- #row -->
			</div><!-- #container -->
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- .wrap -->

<?php get_footer();?>