<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Mavix Builder
 */
/**
* Hook - mavix_builder_action_doctype.
*
* @hooked mavix_builder_doctype -  10
*/
do_action( 'mavix_builder_action_doctype' );
?>
<head>
<?php
/**
* Hook - mavix_builder_action_head.
*
* @hooked mavix_builder_head -  10
*/
do_action( 'mavix_builder_action_head' );
?>

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php do_action( 'wp_body_open' ); ?>

<?php

/**
* Hook - mavix_builder_action_before.
*
* @hooked mavix_builder_page_start - 10
*/
do_action( 'mavix_builder_action_before' );

/**
*
* @hooked mavix_builder_header_start - 10
*/
do_action( 'mavix_builder_action_before_header' );

/**
*
*@hooked mavix_builder_site_branding - 10
*@hooked mavix_builder_header_end - 15 
*/
do_action('mavix_builder_action_header');

/**
*
* @hooked mavix_builder_content_start - 10
*/
do_action( 'mavix_builder_action_before_content' );

/**
 * Banner start
 * 
 * @hooked mavix_builder_banner_header - 10
*/
do_action( 'mavix_builder_banner_header' );  
