<?php
/**
 * Template for displaying a search form on a search page or as a widget.
 *
 * @package mateo
 */

$mateo_search_id = esc_attr( wp_generate_uuid4() );
?>
<form role="search" method="get" class="search-form form-inline" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<div class="form-group bmd-form-group">
		<label for="<?php echo $mateo_search_id; // phpcs:ignore ?>" class="bmd-label-floating"><?php esc_html_e( 'Search', 'mateo' ); ?></label>
		<input type="search" id="<?php echo $mateo_search_id; // phpcs:ignore ?>" class="search-field form-control" value="<?php the_search_query(); ?>" name="s" required>
		<button type="submit" class="search-submit">
			<i class="material-icons" aria-hidden="true">search</i>
			<span class="screen-reader-text"><?php echo esc_html_x( 'Search', 'submit button', 'mateo' ); ?></span>
		</button>
	</div>
</form>
<?php unset( $mateo_search_id ); ?>
